/*
 * Decompiled with CFR 0.152.
 */
package info.malenkov.aspiabook;

import info.malenkov.aspiabook.SPRMatch;
import info.malenkov.aspiabook.proto.Encryption;
import java.math.BigInteger;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.Arrays;

public class SPREngine {
    private final int kIVSize = 12;
    private final int kTagSize = 16;
    private final int kSaltSize = 64;
    private final int kSessKeySize = 32;
    private final String kDefaultGroup = "4096";
    private BigInteger N = null;
    private BigInteger g = null;
    private BigInteger A = null;
    private BigInteger a = null;
    private BigInteger B = null;
    private BigInteger s = null;
    private BigInteger u = null;
    private BigInteger x = null;
    private BigInteger v = null;
    private BigInteger b = null;
    private BigInteger client_key = null;
    private BigInteger server_key = null;
    private BigInteger session_key = null;
    private BigInteger decrypt_iv = null;
    private BigInteger iv = null;
    private Cipher cipher;
    private Encryption encryptionAlgo = Encryption.ENCRYPTION_UNKNOWN;
    private final BigInteger BN_kSrpGroup_1024 = SPRMatch.BA2BI(SPRMatch.HS2BA("EEAF0AB9ADB38DD69C33F80AFA8FC5E86072618775FF3C0B9EA2314C9C256576D674DF7496EA81D3383B4813D692C6E0E0D5D8E250B98BE48E495C1D6089DAD15DC7D7B46154D6B6CE8EF4AD69B15D4982559B297BCF1885C529F566660E57EC68EDBC3C05726CC02FD4CBF4976EAA9AFD5138FE8376435B9FC61D2FC0EB06E3"));
    private final BigInteger BN_kSrpGroup_1536 = SPRMatch.BA2BI(SPRMatch.HS2BA("9DEF3CAFB939277AB1F12A8617A47BBBDBA51DF499AC4C80BEEEA9614B19CC4D5F4F5F556E27CBDE51C6A94BE4607A291558903BA0D0F84380B655BB9A22E8DCDF028A7CEC67F0D08134B1C8B97989149B609E0BE3BAB63D47548381DBC5B1FC764E3F4B53DD9DA1158BFD3E2B9C8CF56EDF019539349627DB2FD53D24B7C48665772E437D6C7F8CE442734AF7CCB7AE837C264AE3A9BEB87F8A2FE9B8B5292E5A021FFF5E91479E8CE7A28C2442C6F315180F93499A234DCF76E3FED135F9BB"));
    private final BigInteger BN_kSrpGroup_2048 = SPRMatch.BA2BI(SPRMatch.HS2BA("AC6BDB41324A9A9BF166DE5E1389582FAF72B6651987EE07FC3192943DB56050A37329CBB4A099ED8193E0757767A13DD52312AB4B03310DCD7F48A9DA04FD50E8083969EDB767B0CF6095179A163AB3661A05FBD5FAAAE82918A9962F0B93B855F97993EC975EEAA80D740ADBF4FF747359D041D5C33EA71D281E446B14773BCA97B43A23FB801676BD207A436C6481F1D2B9078717461A5B9D32E688F87748544523B524B0D57D5EA77A2775D2ECFA032CFBDBF52FB3786160279004E57AE6AF874E7303CE53299CCC041C7BC308D82A5698F3A8D0C38271AE35F8E9DBFBB694B5C803D89F7AE435DE236D525F54759B65E372FCD68EF20FA7111F9E4AFF73"));
    private final BigInteger BN_kSrpGroup_3072 = SPRMatch.BA2BI(SPRMatch.HS2BA("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF"));
    private final BigInteger BN_kSrpGroup_4096 = SPRMatch.BA2BI(SPRMatch.HS2BA("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A92108011A723C12A787E6D788719A10BDBA5B2699C327186AF4E23C1A946834B6150BDA2583E9CA2AD44CE8DBBBC2DB04DE8EF92E8EFC141FBECAA6287C59474E6BC05D99B2964FA090C3A2233BA186515BE7ED1F612970CEE2D7AFB81BDD762170481CD0069127D5B05AA993B4EA988D8FDDC186FFB7DC90A6C08F4DF435C934063199FFFFFFFFFFFFFFFF"));
    private final BigInteger BN_kSrpGroup_6144 = SPRMatch.BA2BI(SPRMatch.HS2BA("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A92108011A723C12A787E6D788719A10BDBA5B2699C327186AF4E23C1A946834B6150BDA2583E9CA2AD44CE8DBBBC2DB04DE8EF92E8EFC141FBECAA6287C59474E6BC05D99B2964FA090C3A2233BA186515BE7ED1F612970CEE2D7AFB81BDD762170481CD0069127D5B05AA993B4EA988D8FDDC186FFB7DC90A6C08F4DF435C93402849236C3FAB4D27C7026C1D4DCB2602646DEC9751E763DBA37BDF8FF9406AD9E530EE5DB382F413001AEB06A53ED9027D831179727B0865A8918DA3EDBEBCF9B14ED44CE6CBACED4BB1BDB7F1447E6CC254B332051512BD7AF426FB8F401378CD2BF5983CA01C64B92ECF032EA15D1721D03F482D7CE6E74FEF6D55E702F46980C82B5A84031900B1C9E59E7C97FBEC7E8F323A97A7E36CC88BE0F1D45B7FF585AC54BD407B22B4154AACC8F6D7EBF48E1D814CC5ED20F8037E0A79715EEF29BE32806A1D58BB7C5DA76F550AA3D8A1FBFF0EB19CCB1A313D55CDA56C9EC2EF29632387FE8D76E3C0468043E8F663F4860EE12BF2D5B0B7474D6E694F91E6DCC4024FFFFFFFFFFFFFFFF"));
    private final BigInteger BN_kSrpGroup_8192 = SPRMatch.BA2BI(SPRMatch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
    private final BigInteger BN_kSrpGenerator_2 = new BigInteger("2", 10);
    private final BigInteger BN_kSrpGenerator_5 = new BigInteger("5", 10);
    private final BigInteger BN_kSrpGenerator_19 = new BigInteger("19", 10);
    private final SrpNgPair kSrpNgPair_1024 = new SrpNgPair(this.BN_kSrpGroup_1024, this.BN_kSrpGenerator_2);
    private final SrpNgPair kSrpNgPair_1536 = new SrpNgPair(this.BN_kSrpGroup_1536, this.BN_kSrpGenerator_2);
    private final SrpNgPair kSrpNgPair_2048 = new SrpNgPair(this.BN_kSrpGroup_2048, this.BN_kSrpGenerator_2);
    private final SrpNgPair kSrpNgPair_3072 = new SrpNgPair(this.BN_kSrpGroup_3072, this.BN_kSrpGenerator_5);
    private final SrpNgPair kSrpNgPair_4096 = new SrpNgPair(this.BN_kSrpGroup_4096, this.BN_kSrpGenerator_5);
    private final SrpNgPair kSrpNgPair_6144 = new SrpNgPair(this.BN_kSrpGroup_6144, this.BN_kSrpGenerator_5);
    private final SrpNgPair kSrpNgPair_8192 = new SrpNgPair(this.BN_kSrpGroup_8192, this.BN_kSrpGenerator_19);

    private SrpNgPair pairByGroup(String group) {
        if (group == "8192") {
            return this.kSrpNgPair_8192;
        }
        if (group == "6144") {
            return this.kSrpNgPair_6144;
        }
        if (group == "4096") {
            return this.kSrpNgPair_4096;
        }
        if (group == "3072") {
            return this.kSrpNgPair_3072;
        }
        if (group == "2048") {
            return this.kSrpNgPair_2048;
        }
        if (group == "1536") {
            return this.kSrpNgPair_1536;
        }
        if (group == "1024") {
            return this.kSrpNgPair_1024;
        }
        return null;
    }

    SPREngine(String user, String password, Encryption algorithm, byte[] number, byte[] generator, byte[] salt, byte[] srvB, byte[] srvIV) throws Exception {
        this.iv = this.genIV();
        this.encryptionAlgo = algorithm;
        this.N = SPRMatch.BA2BI(number);
        this.g = SPRMatch.BA2BI(generator);
        this.s = SPRMatch.BA2BI(salt);
        this.B = SPRMatch.BA2BI(srvB);
        this.decrypt_iv = SPRMatch.BA2BI(srvIV);
        this.a = SPRMatch.RAND(1024, new SecureRandom());
        this.A = SPRMatch.calc_A(this.a, this.N, this.g);
        this.u = SPRMatch.calc_u(this.A, this.B, this.N);
        this.x = SPRMatch.calc_x(this.s, user, password);
        this.client_key = SPRMatch.calcClientKey(this.N, this.B, this.g, this.x, this.a, this.u);
        this.session_key = SPRMatch.hash_BLAKE2s256(this.client_key);
    }

    SPREngine(String user, Encryption algorithm) throws Exception {
        SrpNgPair srpNgPair = this.pairByGroup("4096");
        this.encryptionAlgo = algorithm;
        this.N = srpNgPair.getSrpGroup();
        this.g = srpNgPair.getSprGenerator();
        this.s = SPRMatch.RAND(512, new SecureRandom());
        this.v = SPRMatch.calc_v(user, "9062190680", this.s, this.N, this.g);
        this.b = SPRMatch.RAND(1024, new SecureRandom());
        this.B = SPRMatch.calc_B(this.b, this.N, this.g, this.v);
        this.iv = this.genIV();
    }

    public BigInteger genIV() {
        return SPRMatch.RAND(96, new SecureRandom());
    }

    public void genServerKey() throws NoSuchAlgorithmException {
        this.u = SPRMatch.calc_u(this.A, this.B, this.N);
        this.server_key = SPRMatch.calcServerKey(this.A, this.v, this.u, this.b, this.N);
        this.session_key = SPRMatch.hash_BLAKE2s256(this.server_key);
    }

    public void setA(byte[] A) {
        this.A = SPRMatch.BA2BI(A);
    }

    public void setClientIV(byte[] iv) {
        this.decrypt_iv = SPRMatch.BA2BI(iv);
    }

    public byte[] getKey() {
        return SPRMatch.BI2BA(this.client_key);
    }

    public byte[] getIV() {
        return SPRMatch.BI2BA(this.iv, 12);
    }

    public byte[] getA() {
        return SPRMatch.BI2BA(this.A);
    }

    public byte[] getB() {
        return SPRMatch.BI2BA(this.B);
    }

    public byte[] geta() {
        return SPRMatch.BI2BA(this.a);
    }

    public byte[] getSessionKey() {
        return SPRMatch.BI2BA(this.session_key);
    }

    public byte[] getNumber() {
        return SPRMatch.BI2BA(this.N);
    }

    public byte[] getGenerator() {
        return SPRMatch.BI2BA(this.g);
    }

    public byte[] getSalt() {
        return SPRMatch.BI2BA(this.s);
    }

    public byte[] encrypt(byte[] data) throws Exception {
        SecretKeySpec keySpec = null;
        switch (this.encryptionAlgo) {
            case ENCRYPTION_AES256_GCM: {
                this.cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
                keySpec = new SecretKeySpec(SPRMatch.BI2BA(this.session_key, 32), "AES");
                GCMParameterSpec gcmSpec = new GCMParameterSpec(128, SPRMatch.BI2BA(this.iv, 12));
                this.cipher.init(1, (Key)keySpec, gcmSpec);
                break;
            }
            case ENCRYPTION_CHACHA20_POLY1305: {
                this.cipher = Cipher.getInstance("ChaCha20-Poly1305", "BC");
                keySpec = new SecretKeySpec(SPRMatch.BI2BA(this.session_key, 32), "ChaCha20-Poly1305");
                IvParameterSpec ivSpec = new IvParameterSpec(SPRMatch.BI2BA(this.iv, 12));
                this.cipher.init(1, (Key)keySpec, ivSpec);
                break;
            }
            default: {
                throw new Exception("SPREngine.encrypt(): Unknown encryption algorithm...");
            }
        }
        byte[] encrypted = this.cipher.doFinal(data);
        byte[] tag = Arrays.copyOfRange((byte[])encrypted, (int)(encrypted.length - 16), (int)encrypted.length);
        byte[] body = Arrays.copyOfRange((byte[])encrypted, (int)0, (int)(encrypted.length - 16));
        this.iv = SPRMatch.increment(this.iv);
        return Arrays.concatenate((byte[])tag, (byte[])body);
    }

    public byte[] decrypt(byte[] data) throws Exception {
        SecretKeySpec keySpec = null;
        byte[] tag = Arrays.copyOfRange((byte[])data, (int)0, (int)16);
        byte[] body = Arrays.copyOfRange((byte[])data, (int)16, (int)data.length);
        switch (this.encryptionAlgo) {
            case ENCRYPTION_AES256_GCM: {
                this.cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
                keySpec = new SecretKeySpec(SPRMatch.BI2BA(this.session_key, 32), "AES");
                GCMParameterSpec gcmSpec = new GCMParameterSpec(128, SPRMatch.BI2BA(this.decrypt_iv, 12));
                this.cipher.init(2, (Key)keySpec, gcmSpec);
                break;
            }
            case ENCRYPTION_CHACHA20_POLY1305: {
                this.cipher = Cipher.getInstance("ChaCha20-Poly1305", "BC");
                keySpec = new SecretKeySpec(SPRMatch.BI2BA(this.session_key, 32), "ChaCha20-Poly1305");
                IvParameterSpec ivSpec = new IvParameterSpec(SPRMatch.BI2BA(this.decrypt_iv, 12));
                this.cipher.init(2, (Key)keySpec, ivSpec);
                break;
            }
            default: {
                throw new Exception("SPREngine.decryp(): Unknown encryption algorithm...");
            }
        }
        this.decrypt_iv = SPRMatch.increment(this.decrypt_iv);
        return this.cipher.doFinal(Arrays.concatenate((byte[])body, (byte[])tag));
    }

    private class SrpNgPair {
        private BigInteger BN_kSrpGroup;
        private BigInteger BN_kSrpGenerator;

        public SrpNgPair(BigInteger BN_kSrpGroup, BigInteger BN_kSrpGenerator) {
            this.BN_kSrpGroup = BN_kSrpGroup;
            this.BN_kSrpGenerator = BN_kSrpGenerator;
        }

        public BigInteger getSrpGroup() {
            return this.BN_kSrpGroup;
        }

        public BigInteger getSprGenerator() {
            return this.BN_kSrpGenerator;
        }
    }
}

