/*
 * Decompiled with CFR 0.152.
 */
package info.malenkov.aspiabook;

import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import info.malenkov.aspiabook.SPREngine;
import info.malenkov.aspiabook.proto.ClientHello;
import info.malenkov.aspiabook.proto.Computer;
import info.malenkov.aspiabook.proto.ComputerGroup;
import info.malenkov.aspiabook.proto.Data;
import info.malenkov.aspiabook.proto.Encryption;
import info.malenkov.aspiabook.proto.File;
import info.malenkov.aspiabook.proto.Identify;
import info.malenkov.aspiabook.proto.ServerHello;
import info.malenkov.aspiabook.proto.SessionChallenge;
import info.malenkov.aspiabook.proto.SrpClientKeyExchange;
import info.malenkov.aspiabook.proto.SrpIdentify;
import info.malenkov.aspiabook.proto.SrpServerKeyExchange;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.net.util.SubnetUtils;
import org.bouncycastle.crypto.generators.SCrypt;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;

public class AspiaBook {
    private static final int abMajorVersion = 1;
    private static final int abMinorVesion = 3;
    private final int THREADS_POOL_SIZE = 20;
    private final int TIMEOUT = 500;
    private final String SPLIT = "<-//->";
    private boolean aabEncrypted = false;
    private String aabPath = null;
    private String aabPathWrite = null;
    private String aabPassword = null;
    private byte[] aabData = null;
    private String jsonPath = null;
    private String ipNet = null;
    private int aspiaPort = 8050;
    private boolean saveIp = false;
    private int ipTimeout = 500;
    private String hostUser = "";
    private String hostPassword = "";
    private boolean saveCred = false;
    private static String abName = "AspiaBook";
    private static String abCopyright = "(c) Copyright 2024 Maxim V. Malenkov\n\nThird-party component:\n- guava (c) 2009 Google Inc.; Apache-2.0 license\n- protobuf (c) 2008 Google Inc.; BSD 3-Clause License\n- bouncycastle (c) 2000 - 2021 The Legion of the Bouncy Castle Inc; MIT license";
    private List<HostInfo> foundHosts = new ArrayList<HostInfo>();

    AspiaBook() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void printVersion() {
        System.out.println(abName + " v." + 1 + "." + 3);
        System.out.println(abCopyright);
        System.out.println("");
        if (System.getProperty("java.vendor").length() > 0 && System.getProperty("java.version").length() > 0) {
            System.out.println("JavaVM version: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
            if (System.getProperty("os.name").length() > 0 && System.getProperty("os.arch").length() > 0) {
                System.out.println("Running on " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")");
            }
        }
        System.out.println("");
    }

    public void saveIpOnly(boolean saveIp) {
        this.saveIp = saveIp;
    }

    public void setPath(String aabPath) {
        this.aabPath = aabPath;
    }

    public void setHostUser(String user) {
        this.hostUser = user;
    }

    public void setHostPassword(String password) {
        this.hostPassword = password;
    }

    public void setPathWrite(String aabPathWrite) {
        this.aabPathWrite = aabPathWrite;
    }

    public void setPassword(String aabPassword) {
        this.aabPassword = aabPassword;
        if (aabPassword != null && aabPassword != "") {
            this.aabEncrypted = true;
        }
    }

    public void setPathJSON(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public void setNet(String ipNet) {
        if (ipNet.indexOf(":") > 0) {
            String[] buffer = ipNet.split(":");
            this.ipNet = buffer[0];
            this.aspiaPort = Integer.valueOf(buffer[1]);
        } else {
            this.ipNet = ipNet;
        }
    }

    public void setTimeout(int timeout) {
        this.ipTimeout = timeout < 200 ? 200 : (timeout > 5000 ? 5000 : timeout);
    }

    public void saveCredential(boolean cred) {
        this.saveCred = cred;
    }

    /*
     * WARNING - void declaration
     */
    public void netScan() throws InterruptedException, ExecutionException, UnknownHostException {
        Date date = new Date();
        if (this.ipNet != null) {
            void var8_11;
            SubnetUtils utils = new SubnetUtils(this.ipNet);
            String[] allIps = utils.getInfo().getAllAddresses();
            ExecutorService es = Executors.newFixedThreadPool(20);
            ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
            String[] stringArray = allIps;
            int n = stringArray.length;
            boolean bl = false;
            while (var8_11 < n) {
                String ip = stringArray[var8_11];
                futures.add(this.portIsOpen(es, ip, this.aspiaPort, this.ipTimeout));
                ++var8_11;
            }
            es.shutdown();
            int openPorts = 0;
            for (Future future : futures) {
                if (!((Boolean)future.get()).booleanValue()) continue;
                ++openPorts;
            }
            System.out.println("\nThere are " + openPorts + " open ports on network " + this.ipNet + " (probed with a timeout of " + this.ipTimeout + "ms)");
            if (openPorts > 0) {
                void var8_14;
                ComputerGroup computerGroup = ComputerGroup.newBuilder().build();
                boolean bl2 = false;
                while (var8_14 < this.foundHosts.size()) {
                    String tmpName = "";
                    String tmpComment = "";
                    String tmpUser = "";
                    String tmpPassword = "";
                    if (this.saveCred) {
                        tmpUser = this.hostUser;
                        tmpPassword = this.hostPassword;
                    }
                    if (this.foundHosts.get((int)var8_14).getName().indexOf("<-//->") > 0) {
                        String[] temp = this.foundHosts.get((int)var8_14).getName().split("<-//->");
                        tmpName = temp[0];
                        tmpComment = temp[1];
                    } else {
                        tmpName = this.foundHosts.get((int)var8_14).getIp();
                        tmpComment = this.foundHosts.get((int)var8_14).getName();
                    }
                    Computer computer = Computer.newBuilder().setUsername(tmpUser).setPassword(tmpPassword).setName(tmpName).setComment(tmpComment).setAddress(this.foundHosts.get((int)var8_14).getIp()).setPort(this.aspiaPort).setCreateTime(date.getTime() / 1000L).setModifyTime(date.getTime() / 1000L).build();
                    computerGroup = ComputerGroup.newBuilder(computerGroup).addComputer(computer).build();
                    ++var8_14;
                }
                this.aabData = Data.newBuilder().mergeRootGroup(computerGroup).build().toByteArray();
            } else {
                this.aabData = null;
            }
        }
    }

    public boolean load() {
        boolean result = false;
        if (this.aabPath != null) {
            try {
                byte[] aabBuffer = Files.readAllBytes(FileSystems.getDefault().getPath(this.aabPath, new String[0]));
                File aspiaAddressBookFile = File.parseFrom(aabBuffer);
                switch (aspiaAddressBookFile.getEncryptionType()) {
                    case ENCRYPTION_TYPE_CHACHA20_POLY1305: {
                        this.aabData = this.decrypt(aspiaAddressBookFile.getData().toByteArray(), aspiaAddressBookFile.getHashingSalt().toByteArray(), this.aabPassword.getBytes());
                        result = true;
                        break;
                    }
                    case ENCRYPTION_TYPE_NONE: {
                        this.aabData = aspiaAddressBookFile.getData().toByteArray();
                        result = true;
                        break;
                    }
                    default: {
                        System.out.println("<!> ERROR: The address book file is encrypted with an unsupported encryption type.");
                        break;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("<!> AspiaBook.load() error:\n" + e);
            }
        }
        return result;
    }

    public boolean save() {
        boolean result = false;
        if (this.aabPathWrite != null && this.aabData != null) {
            try {
                if (this.aabEncrypted) {
                    byte[] newSalt = this.newSalt();
                    byte[] aabEncryptedData = this.encrypt(this.aabData, newSalt, this.aabPassword.getBytes());
                    File aabOut = File.newBuilder().setData(ByteString.copyFrom((byte[])aabEncryptedData)).setHashingSalt(ByteString.copyFrom((byte[])newSalt)).setEncryptionTypeValue(3).build();
                    aabOut.writeTo(new FileOutputStream(this.aabPathWrite, false));
                    result = true;
                } else {
                    File aabOut = File.newBuilder().setData(ByteString.copyFrom((byte[])this.aabData)).setEncryptionTypeValue(1).build();
                    aabOut.writeTo(new FileOutputStream(this.aabPathWrite, false));
                    result = true;
                }
            }
            catch (Exception e) {
                System.out.println("<!> AspiaBook.save() error:\n" + e);
            }
        }
        return result;
    }

    public boolean export() {
        boolean result = false;
        if (this.aabPath == null) {
            System.out.println("<!> AspiaBook.export() error: Undefinded path to Aspia address book file...");
        } else if (this.jsonPath == null) {
            System.out.println("<!> AspiaBook.export() error: Undefinded path to JSON file...");
        } else {
            try {
                Data data = Data.parseFrom(this.aabData);
                if (data.isInitialized()) {
                    byte[] strToBytes = this.toJSON(data.getAllFields()).getBytes();
                    FileOutputStream outputStream = new FileOutputStream(this.jsonPath);
                    outputStream.write(strToBytes);
                    outputStream.close();
                }
            }
            catch (Exception e) {
                System.out.println("<!> AspiaBook.export() error:\n" + e);
            }
        }
        return result;
    }

    private byte[] decrypt(byte[] data, byte[] salt, byte[] password) throws Exception {
        int kIVSize = 12;
        int kTagSize = 16;
        byte[] iv = Arrays.copyOfRange((byte[])data, (int)0, (int)12);
        byte[] tag = Arrays.copyOfRange((byte[])data, (int)12, (int)28);
        byte[] body = Arrays.copyOfRange((byte[])data, (int)28, (int)data.length);
        Cipher cipher = Cipher.getInstance("ChaCha20-Poly1305", "BC");
        SecretKeySpec keySpec = new SecretKeySpec(this.hash(password, salt), "ChaCha20-Poly1305");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)keySpec, ivSpec);
        return cipher.doFinal(Arrays.concatenate((byte[])body, (byte[])tag));
    }

    public byte[] encrypt(byte[] data, byte[] salt, byte[] password) throws Exception {
        int kTagSize = 16;
        byte[] iv = this.newIV();
        Cipher cipher = Cipher.getInstance("ChaCha20-Poly1305", "BC");
        SecretKeySpec keySpec = new SecretKeySpec(this.hash(password, salt), "ChaCha20-Poly1305");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)keySpec, ivSpec);
        byte[] encrypted = cipher.doFinal(data);
        byte[] tag = Arrays.copyOfRange((byte[])encrypted, (int)(encrypted.length - 16), (int)encrypted.length);
        byte[] body = Arrays.copyOfRange((byte[])encrypted, (int)0, (int)(encrypted.length - 16));
        return Arrays.concatenate((byte[])iv, (byte[])Arrays.concatenate((byte[])tag, (byte[])body));
    }

    private byte[] hash(byte[] password, byte[] salt) {
        int N = 16384;
        int r = 8;
        int p = 2;
        int kBitsPerByte = 8;
        int kBitsSize = 256;
        int kBytesSize = 32;
        return SCrypt.generate((byte[])password, (byte[])salt, (int)16384, (int)8, (int)2, (int)32);
    }

    private byte[] newSalt() {
        byte[] buffer = new byte[256];
        new SecureRandom().nextBytes(buffer);
        return buffer;
    }

    private byte[] newIV() {
        byte[] buffer = new byte[12];
        new SecureRandom().nextBytes(buffer);
        return buffer;
    }

    private String toJSON(Object object) {
        Gson gson = new Gson();
        return gson.toJson(object);
    }

    private Future<Boolean> portIsOpen(ExecutorService es, final String ip, final int port, final int timeout) {
        return es.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    String tmpIp = null;
                    String tmpHost = null;
                    Socket socket = new Socket();
                    socket.connect(new InetSocketAddress(ip, port), timeout);
                    socket.close();
                    if (AspiaBook.this.saveIp) {
                        tmpIp = ip;
                        tmpHost = AspiaBook.this.getHostInfo(ip, AspiaBook.this.hostUser, AspiaBook.this.hostPassword);
                    } else {
                        tmpIp = AspiaBook.this.getHostName(ip);
                        tmpHost = AspiaBook.this.getHostInfo(ip, AspiaBook.this.hostUser, AspiaBook.this.hostPassword);
                    }
                    AspiaBook.this.foundHosts.add(new HostInfo(tmpIp, tmpHost));
                    System.out.print("+");
                    return true;
                }
                catch (Exception ex) {
                    System.out.print(".");
                    return false;
                }
            }
        });
    }

    private String getHostName(String ip) {
        String result = ip;
        try {
            InetAddress addr = InetAddress.getByName(ip);
            result = addr.getHostName();
        }
        catch (UnknownHostException e) {
            System.out.println("\n<!>getHostName(" + ip + ") error: " + e);
        }
        return result;
    }

    private String getHostInfo(String hostIp, String hostUser, String hostPassword) {
        String result = "<!> Wrong user name or password";
        Encryption serverEncryption = Encryption.ENCRYPTION_UNKNOWN;
        SPREngine sprEngine = null;
        boolean alwaysFine = true;
        byte[] data = null;
        try {
            Socket socket = new Socket(hostIp, this.aspiaPort);
            socket.setSoTimeout(this.ipTimeout);
            BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
            BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
            ClientHello clientHello = ClientHello.newBuilder().setEncryption(3).setIdentify(Identify.IDENTIFY_SRP).build();
            byte[] clientHelloDATA = this.addSize(clientHello.toByteArray());
            out.write(clientHelloDATA);
            out.flush();
            if (alwaysFine) {
                data = this.read(in);
                if (data.length > 0) {
                    if (this.var128Decode(data = this.skipSize(data)) > 0L) {
                        ServerHello serverHello = ServerHello.parseFrom(data);
                        serverEncryption = serverHello.getEncryption();
                    } else {
                        System.out.print("<!> ServerHello protobuf error.");
                        alwaysFine = false;
                    }
                } else {
                    System.out.print("<!> ServerHello error.");
                    alwaysFine = false;
                }
            }
            if (alwaysFine) {
                SrpIdentify srpIdentify = SrpIdentify.newBuilder().setUsername(hostUser).build();
                byte[] srpIdentifyDATA = this.addSize(srpIdentify.toByteArray());
                out.write(srpIdentifyDATA);
                out.flush();
            }
            if (alwaysFine) {
                data = this.read(in);
                if (data.length > 0) {
                    if (this.var128Decode(data) > 0L) {
                        data = this.skipSize(data);
                        SrpServerKeyExchange srpServerKeyExchange = SrpServerKeyExchange.parseFrom(data);
                        sprEngine = new SPREngine(hostUser, hostPassword, serverEncryption, srpServerKeyExchange.getNumber().toByteArray(), srpServerKeyExchange.getGenerator().toByteArray(), srpServerKeyExchange.getSalt().toByteArray(), srpServerKeyExchange.getB().toByteArray(), srpServerKeyExchange.getIv().toByteArray());
                    } else {
                        System.out.print("<!> SprServerKeyExchange protobuf error.");
                        alwaysFine = false;
                    }
                } else {
                    System.out.print("<!> SprServerKeyExchange error.");
                    alwaysFine = false;
                }
            }
            if (alwaysFine && sprEngine != null) {
                SrpClientKeyExchange srpClientKeyExchange = SrpClientKeyExchange.newBuilder().setA(ByteString.copyFrom((byte[])sprEngine.getA())).setIv(ByteString.copyFrom((byte[])sprEngine.getIV())).build();
                byte[] srpClientKeyExchangeDATA = this.addSize(srpClientKeyExchange.toByteArray());
                out.write(srpClientKeyExchangeDATA);
                out.flush();
            }
            if (alwaysFine && sprEngine != null) {
                data = this.read(in);
                if (data.length > 0) {
                    if (this.var128Decode(data) > 0L) {
                        data = this.skipSize(data);
                        SessionChallenge sessionChallenge = SessionChallenge.parseFrom(sprEngine.decrypt(data));
                        result = sessionChallenge.getComputerName() + "<-//->" + sessionChallenge.getOsName();
                    } else {
                        result = result + "\nSessionChallenge protobuf error.";
                        alwaysFine = false;
                    }
                } else {
                    result = result + "\nSessionChallenge error.";
                    alwaysFine = false;
                }
            }
            socket.close();
        }
        catch (Exception e) {
            result = result + "\n" + e;
        }
        return result;
    }

    private byte[] addSize(byte[] value) {
        byte[] newBuffer = null;
        if (value.length > 0) {
            int var128Size = this.var128Size(value.length);
            newBuffer = new byte[value.length + var128Size];
            System.arraycopy(this.var128Encode(value.length), 0, newBuffer, 0, var128Size);
            System.arraycopy(value, 0, newBuffer, var128Size, value.length);
        }
        return newBuffer;
    }

    private byte[] skipSize(byte[] value) {
        byte[] newBuffer = null;
        if (value.length > 0) {
            int msgLen = (int)this.var128Decode(value);
            newBuffer = new byte[msgLen];
            System.arraycopy(value, this.var128Size(msgLen), newBuffer, 0, msgLen);
        }
        return newBuffer;
    }

    private int var128Size(long x) {
        int size = 1;
        while (Long.compareUnsigned(x, 127L) > 0) {
            ++size;
            x >>>= 7;
        }
        return size;
    }

    private byte[] var128Encode(long x) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[this.var128Size(x)]);
        while (Long.compareUnsigned(x, 127L) > 0) {
            bb.put((byte)(x & 0x7FL | 0x80L));
            x >>>= 7;
        }
        bb.put((byte)(x & 0x7FL));
        return bb.array();
    }

    private long var128Decode(byte[] buffer) {
        long b;
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        long x = 0L;
        int shift = 0;
        do {
            b = bb.get() & 0xFF;
            x |= (b & 0x7FL) << shift;
            shift += 7;
        } while ((b & 0x80L) != 0L);
        return x;
    }

    private byte[] read(BufferedInputStream in) throws IOException, InterruptedException {
        int termLength = 0;
        byte[] buffer = new byte[]{};
        byte[] term = new byte[16384];
        do {
            termLength = in.read(term, 0, 16384);
            buffer = this.concatenate(buffer, term, termLength);
            Thread.sleep(100L);
        } while (in.available() > 0);
        return buffer;
    }

    private byte[] concatenate(byte[] first, byte[] second, int length) {
        byte[] combined = new byte[first.length + length];
        if (first.length > 0) {
            System.arraycopy(first, 0, combined, 0, first.length);
        }
        if (second.length > 0) {
            System.arraycopy(second, 0, combined, first.length, length);
        }
        return combined;
    }

    class HostInfo {
        String hostIp;
        String hostName;

        public HostInfo(String ip, String name) {
            this.hostIp = ip;
            this.hostName = name;
        }

        public String getIp() {
            return this.hostIp;
        }

        public String getName() {
            return this.hostName;
        }
    }
}

