/*
 * Decompiled with CFR 0.152.
 */
package info.malenkov.aspiabot;

public class CommandLineParcer {
    final String separator = "=";
    String[] args;
    String[] keys;
    boolean caseSensitive = false;
    int keysCount = 0;

    public CommandLineParcer(String[] args) {
        this.args = args;
        this.fixParameters();
    }

    public CommandLineParcer(String[] args, String[] keys) {
        this.args = args;
        this.keys = keys;
        this.fixParameters();
    }

    public CommandLineParcer(String[] args, String[] keys, boolean caseSensitive) {
        this.args = args;
        this.keys = keys;
        this.caseSensitive = caseSensitive;
        this.fixParameters();
    }

    public boolean isKeyExist(String keyName) {
        boolean result = false;
        int separatorPosition = 0;
        for (String key : this.args) {
            if (key.length() <= 0) continue;
            separatorPosition = key.indexOf("=");
            if (separatorPosition > 0) {
                key = key.substring(0, separatorPosition).trim();
            }
            if (this.caseSensitive) {
                if (!key.equals(keyName.trim())) continue;
                result = true;
                break;
            }
            if (!key.toUpperCase().equals(keyName.trim().toUpperCase())) continue;
            result = true;
            break;
        }
        return result;
    }

    public String getKeyValue(String keyName) {
        String result = null;
        int separatorPosition = 0;
        for (String key : this.args) {
            String value = null;
            separatorPosition = key.indexOf("=");
            if (separatorPosition > 0) {
                value = key.substring(separatorPosition + 1).trim();
                key = key.substring(0, separatorPosition).trim();
            }
            if (this.caseSensitive) {
                if (!key.equals(keyName.trim())) continue;
                result = value;
                break;
            }
            if (!key.toUpperCase().equals(keyName.trim().toUpperCase())) continue;
            result = value;
            break;
        }
        return result;
    }

    public int getKeysCount() {
        return this.keysCount;
    }

    public int getUnknownKeysCount() {
        int separatorPosition = 0;
        boolean keyFound = false;
        int result = 0;
        if (this.keys.length > 0) {
            for (String key : this.args) {
                if (key.length() <= 0) continue;
                keyFound = false;
                separatorPosition = key.indexOf("=");
                if (separatorPosition > 0) {
                    key = key.substring(0, separatorPosition).trim();
                }
                for (String trueKey : this.keys) {
                    if (this.caseSensitive) {
                        if (!key.equals(trueKey)) continue;
                        keyFound = true;
                        break;
                    }
                    if (!key.toLowerCase().equals(trueKey.toLowerCase())) continue;
                    keyFound = true;
                    break;
                }
                if (keyFound) continue;
                ++result;
            }
        }
        return result;
    }

    public String[] getUnknownKeys() {
        int separatorPosition = 0;
        boolean keyFound = false;
        int wrongKeysCount = this.getUnknownKeysCount();
        String[] wrongKeys = new String[wrongKeysCount];
        int keyNumber = 0;
        if (wrongKeysCount > 0) {
            for (String key : this.args) {
                if (key.length() <= 0) continue;
                keyFound = false;
                separatorPosition = key.indexOf("=");
                if (separatorPosition > 0) {
                    key = key.substring(0, separatorPosition).trim();
                }
                for (String trueKey : this.keys) {
                    if (this.caseSensitive) {
                        if (!key.equals(trueKey)) continue;
                        keyFound = true;
                        break;
                    }
                    if (!key.toLowerCase().equals(trueKey.toLowerCase())) continue;
                    keyFound = true;
                    break;
                }
                if (keyFound) continue;
                wrongKeys[keyNumber++] = key;
            }
        }
        return wrongKeys;
    }

    private void fixParameters() {
        if (this.keys.length > 0) {
            for (String key : this.args) {
                if (key.length() <= 0) continue;
                if (key.charAt(0) == "'".charAt(0) && key.charAt(key.length() - 1) == "'".charAt(0)) {
                    key = key.substring(1, key.length() - 3);
                    System.out.println(key);
                }
                if (key.charAt(0) == "\"".charAt(0) && key.charAt(key.length() - 1) == "\"".charAt(0)) {
                    key = key.substring(1, key.length() - 3);
                }
                ++this.keysCount;
            }
        }
    }
}

