/*
 * Decompiled with CFR 0.152.
 */
package info.malenkov.aspiabot;

import info.malenkov.aspiabot.AspiaBot;
import info.malenkov.aspiabot.CommandLineParcer;

public class App {
    private static final String CLK_SILENT = "--silent";
    private static final String CLK_SILENT_S = "-s";
    private static final String CLK_DEBUG = "--debug";
    private static final String CLK_DEBUG_S = "-g";
    private static final String CLK_JVM = "--jvm";
    private static final String CLK_JVM_S = "-j";
    private static final String CLK_HOSTS = "--hosts";
    private static final String CLK_HOSTS_S = "-o";
    private static final String CLK_DOMAIN = "--domain";
    private static final String CLK_DOMAIN_S = "-d";
    private static final String CLK_MEMO = "--memo";
    private static final String CLK_MEMO_S = "-m";
    private static final String CLK_TIMEOUT = "--timeout";
    private static final String CLK_TIMEOUT_S = "-t";
    private static final String CLK_ADDRESS = "--address";
    private static final String CLK_ADDRESS_S = "-a";
    private static final String CLK_USER = "--user";
    private static final String CLK_USER_S = "-u";
    private static final String CLK_PASSWORD = "--password";
    private static final String CLK_PASSWORD_S = "-p";
    private static final String CLK_ID = "--id";
    private static final String CLK_ID_S = "-i";
    private static final String CLK_VERSION = "--version";
    private static final String CLK_VERSION_S = "-v";
    private static final String CLK_HELP = "--help";
    private static final String CLK_HELP_S = "-h";
    private static final String CLK_JSON = "--json";
    private static final String CLK_JSON_S = "-n";
    private static String[] commandLineKeys = new String[]{"--silent", "-s", "--debug", "-g", "--jvm", "-j", "--hosts", "-o", "--domain", "-d", "--memo", "-m", "--timeout", "-t", "--address", "-a", "--user", "-u", "--password", "-p", "--id", "-i", "--version", "-v", "--help", "-h", "--json", "-n"};
    private static CommandLineParcer commandLineParcer;

    public static void main(String[] args) throws Exception {
        boolean run = true;
        String jv = System.getProperty("java.version");
        if (jv != null) {
            if (jv.length() > 0 && jv.substring(0, 2).equals("1.") && Integer.parseInt(jv.substring(2, 3)) < 8) {
                App.wrongJava();
                run = false;
            }
        } else {
            App.wrongJava();
            run = false;
        }
        if ((commandLineParcer = new CommandLineParcer(args, commandLineKeys)).getKeysCount() == 0 || commandLineParcer.getUnknownKeysCount() > 0) {
            System.out.println("<!> Keys found: " + commandLineParcer.getKeysCount());
            System.out.println("<!> Unknown keys found: " + commandLineParcer.getUnknownKeysCount());
            System.out.println("<!> Unknown key(s):" + String.join((CharSequence)",", commandLineParcer.getUnknownKeys()) + "\n");
            App.help();
        } else if (commandLineParcer.isKeyExist(CLK_HELP_S) || commandLineParcer.isKeyExist(CLK_HELP)) {
            App.help();
        } else if (commandLineParcer.isKeyExist(CLK_JVM_S) || commandLineParcer.isKeyExist(CLK_JVM)) {
            if (System.getProperty("java.vendor").length() > 0 && System.getProperty("java.version").length() > 0) {
                System.out.println("JavaVM version: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
                if (System.getProperty("os.name").length() > 0 && System.getProperty("os.arch").length() > 0) {
                    System.out.println("Running on " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")");
                }
            }
        } else if (commandLineParcer.isKeyExist(CLK_VERSION_S) || commandLineParcer.isKeyExist(CLK_VERSION)) {
            AspiaBot.printVersion();
        } else {
            if (!commandLineParcer.isKeyExist(CLK_ADDRESS_S) && !commandLineParcer.isKeyExist(CLK_ADDRESS)) {
                System.out.println("<!>: Missing required argument -h=<..>, --host=<..>");
                run = false;
            }
            if (!commandLineParcer.isKeyExist(CLK_USER_S) && !commandLineParcer.isKeyExist(CLK_USER)) {
                System.out.println("<!>: Missing required argument -u=<..>, --file=<..>");
                run = false;
            }
            if (!commandLineParcer.isKeyExist(CLK_PASSWORD_S) && !commandLineParcer.isKeyExist(CLK_PASSWORD)) {
                System.out.println("<!>: Missing required argument -p=<..>, --password=<..>");
                run = false;
            }
            if (commandLineParcer.isKeyExist(CLK_ADDRESS_S)) {
                AspiaBot.setAddress(commandLineParcer.getKeyValue(CLK_ADDRESS_S));
            }
            if (commandLineParcer.isKeyExist(CLK_ADDRESS)) {
                AspiaBot.setAddress(commandLineParcer.getKeyValue(CLK_ADDRESS));
            }
            if (commandLineParcer.isKeyExist(CLK_USER_S)) {
                AspiaBot.setUser(commandLineParcer.getKeyValue(CLK_USER_S));
            }
            if (commandLineParcer.isKeyExist(CLK_USER)) {
                AspiaBot.setUser(commandLineParcer.getKeyValue(CLK_USER));
            }
            if (commandLineParcer.isKeyExist(CLK_PASSWORD_S)) {
                AspiaBot.setPassword(commandLineParcer.getKeyValue(CLK_PASSWORD_S));
            }
            if (commandLineParcer.isKeyExist(CLK_PASSWORD)) {
                AspiaBot.setPassword(commandLineParcer.getKeyValue(CLK_PASSWORD));
            }
            if (commandLineParcer.isKeyExist(CLK_DEBUG_S) || commandLineParcer.isKeyExist(CLK_DEBUG)) {
                AspiaBot.setDebug(true);
            }
            if (commandLineParcer.isKeyExist(CLK_JVM_S) || commandLineParcer.isKeyExist(CLK_JVM)) {
                AspiaBot.setJVMInfo(true);
            }
            if (commandLineParcer.isKeyExist(CLK_HOSTS_S)) {
                AspiaBot.setHosts(commandLineParcer.getKeyValue(CLK_HOSTS_S));
            }
            if (commandLineParcer.isKeyExist(CLK_HOSTS)) {
                AspiaBot.setHosts(commandLineParcer.getKeyValue(CLK_HOSTS));
            }
            if (commandLineParcer.isKeyExist(CLK_DOMAIN_S)) {
                AspiaBot.setDomain(commandLineParcer.getKeyValue(CLK_DOMAIN_S));
            }
            if (commandLineParcer.isKeyExist(CLK_DOMAIN)) {
                AspiaBot.setDomain(commandLineParcer.getKeyValue(CLK_DOMAIN));
            }
            if (commandLineParcer.isKeyExist(CLK_MEMO_S)) {
                AspiaBot.setMemo(commandLineParcer.getKeyValue(CLK_MEMO_S));
            }
            if (commandLineParcer.isKeyExist(CLK_MEMO)) {
                AspiaBot.setMemo(commandLineParcer.getKeyValue(CLK_MEMO));
            }
            if (commandLineParcer.isKeyExist(CLK_TIMEOUT_S)) {
                AspiaBot.setTimeout(Integer.valueOf(commandLineParcer.getKeyValue(CLK_TIMEOUT_S)));
            }
            if (commandLineParcer.isKeyExist(CLK_TIMEOUT)) {
                AspiaBot.setTimeout(Integer.valueOf(commandLineParcer.getKeyValue(CLK_TIMEOUT)));
            }
            if (commandLineParcer.isKeyExist(CLK_ID_S)) {
                AspiaBot.setID(Integer.valueOf(commandLineParcer.getKeyValue(CLK_ID_S)).intValue());
            }
            if (commandLineParcer.isKeyExist(CLK_ID)) {
                AspiaBot.setID(Integer.valueOf(commandLineParcer.getKeyValue(CLK_ID)).intValue());
            }
            if (commandLineParcer.isKeyExist(CLK_SILENT_S) || commandLineParcer.isKeyExist(CLK_SILENT)) {
                AspiaBot.setSilent(true);
            }
            if (commandLineParcer.isKeyExist(CLK_JSON_S)) {
                AspiaBot.setJsonFile(commandLineParcer.getKeyValue(CLK_JSON_S));
            }
            if (commandLineParcer.isKeyExist(CLK_JSON)) {
                AspiaBot.setJsonFile(commandLineParcer.getKeyValue(CLK_JSON));
            }
            if (run) {
                AspiaBot.run();
            }
        }
    }

    private static void help() {
        System.out.println("Usage: AspiaBot [-hvsgjdomtin] -a=ip[:port] -u=user -p=password");
        System.out.println();
        System.out.println("Required arguments: ");
        System.out.println("  -a=<..>, --address=<..>\tAspia router IP adress [:optional port numbet]");
        System.out.println("  -u=<..>, --file=<..>\t\tAspia user with administrator rights");
        System.out.println("  -p=<..>, --file=<..>\t\tPassword for Aspia user");
        System.out.println();
        System.out.println("Optional arguments: ");
        System.out.println("  -h, --help\t\t\tthis help");
        System.out.println("  -v, --version\t\t\tprint version");
        System.out.println("  -s, --silent\t\t\tsilent mode");
        System.out.println("  -g, --debug\t\t\tprint full session debug");
        System.out.println("  -j, --jvm\t\t\tprint Java runtime environment");
        System.out.println("  -d, --domain\t\t\tset additional domain name for hosts' records");
        System.out.println("  -o=<..>, --hosts=<..>\t\tpath to system's hosts file");
        System.out.println("  -m=<..>, --memeo=<..>\t\tadd mnemonic names for hosts' records");
        System.out.println("  -t=<..>, --timeout=<..>\tset timeout (in seconds) for TCP/IP session");
        System.out.println("  -i=<..>, --id=<..>\t\tprint TCP/IP address for requred ID");
        System.out.println("  -n=<..>, --json=<..>\t\texport hosts list to json file");
        System.out.println();
        System.out.println("Mandatory arguments to long options are mandatory for short options too.");
        System.out.println();
        System.out.println("Usage example (basic)");
        System.out.println("Linux   : sudo AspiaBot -a=1.2.3.4 -u=admin -p=password -o=/etc/hosts");
        System.out.println("Mac OS  : sudo AspiaBot -a=1.2.3.4 -u=admin -p=password -o=/private/etc/hosts");
        System.out.println("Windows : AspiaBot -a=1.2.3.4 -u=admin -p=password -o=\"c:\\windows\\system32\\drivers\\etc\\hosts\"");
        System.out.println();
        System.out.println("Usage example (advanced)");
        System.out.println("List all active session on router:\n AspiaBot -a=1.2.3.4 -u=admin -p=password");
        System.out.println("Get IP-address by ID:\n AspiaBot -a=1.2.3.4 -u=admin -p=password -i=8 -s");
        System.out.println("Add additional name for some host records:\n sudo AspiaBot -a=1.2.3.4 -u=admin -p=password -o=/etc/hosts -m\"3:sql;9:Fido;18:doe_j\"");
    }

    private static void wrongJava() {
        System.out.println("<!>: Requires Java VM version 8 or higher!");
        System.out.println("Please, download your version from: ");
        System.out.println("1. Oracle - https://www.java.com/");
        System.out.println("2. Azul - https://www.azul.com/");
        System.out.println("3. Gluon - https://gluonhq.com/");
        System.out.println("... or install any other Open Java 8+ build you are prefer.");
    }
}

