/*
 * Decompiled with CFR 0.152.
 */
package info.malenkov.aspiabot;

import com.google.protobuf.ByteString;
import info.malenkov.aspiabot.SPREngine;
import info.malenkov.aspiabot.SPRMatch;
import info.malenkov.aspiabot.proto.AdminToRouter;
import info.malenkov.aspiabot.proto.ClientHello;
import info.malenkov.aspiabot.proto.Encryption;
import info.malenkov.aspiabot.proto.HostSessionData;
import info.malenkov.aspiabot.proto.Identify;
import info.malenkov.aspiabot.proto.RouterToAdmin;
import info.malenkov.aspiabot.proto.ServerHello;
import info.malenkov.aspiabot.proto.Session;
import info.malenkov.aspiabot.proto.SessionChallenge;
import info.malenkov.aspiabot.proto.SessionList;
import info.malenkov.aspiabot.proto.SessionListRequest;
import info.malenkov.aspiabot.proto.SessionResponse;
import info.malenkov.aspiabot.proto.SrpClientKeyExchange;
import info.malenkov.aspiabot.proto.SrpIdentify;
import info.malenkov.aspiabot.proto.SrpServerKeyExchange;
import info.malenkov.aspiabot.proto.Version;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.json.JSONObject;

public class AspiaBot {
    private static final int abMajorVersion = 1;
    private static final int abMinorVesion = 2;
    private static final int abPath = 0;
    private static final int abRevision = 0;
    private static long requestedId = 0L;
    private static boolean silent = false;
    private static boolean debug = false;
    private static boolean printJVMInfo = false;
    private static String hosts = null;
    private static String domain = "";
    private static String memo = null;
    private static String aspiaURL = null;
    private static int aspiaPort = 0;
    private static String aspiaUser = null;
    private static String aspiaPassword = null;
    private static String aspiaJson = null;
    private static int socketTimeout = 0;
    private static String abName = "AspiaBot";
    private static String abOS = "Java VM";
    private static String abCopyright = "(c) Copyright 2024 Maxim V. Malenkov\n\nThird-party component:\n- guava (c) 2009 Google Inc.; Apache-2.0 license\n- protobuf (c) 2008 Google Inc.; BSD 3-Clause License\n- bouncycastle (c) 2000 - 2021 The Legion of the Bouncy Castle Inc; MIT license";

    public static final void run() throws Exception {
        Encryption serverEncryption = Encryption.ENCRYPTION_UNKNOWN;
        SPREngine sprEngine = null;
        boolean alwaysFine = true;
        ArrayList<HostInfo> hostInfoList = new ArrayList<HostInfo>();
        byte[] data = null;
        Security.addProvider((Provider)new BouncyCastleProvider());
        JSONObject table = new JSONObject();
        if (printJVMInfo) {
            AspiaBot.printFullJVMInfo();
        }
        if (!silent || debug) {
            System.out.println("Connecting to " + aspiaURL + ":" + aspiaPort);
            if (InetAddress.getLocalHost().getHostName().length() > 0) {
                abName = InetAddress.getLocalHost().getHostName();
            }
            if (!debug) {
                System.out.println("Please, wait ...");
            }
        }
        try {
            Socket socket = new Socket(aspiaURL, aspiaPort);
            socket.setSoTimeout(socketTimeout);
            BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
            BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
            ClientHello clientHello = ClientHello.newBuilder().setEncryption(3).setIdentify(Identify.IDENTIFY_SRP).build();
            byte[] clientHelloDATA = AspiaBot.addSize(clientHello.toByteArray());
            AspiaBot.debugPrintLn("\n--->>> #1 Sent [ClientHello] " + String.valueOf(clientHelloDATA.length) + " bytes: " + SPRMatch.bytesToHex(clientHelloDATA, new boolean[0]) + "\n");
            out.write(clientHelloDATA);
            out.flush();
            if (alwaysFine) {
                data = AspiaBot.read(in);
                if (data.length > 0) {
                    AspiaBot.debugPrintLn("<<<--- Received " + String.valueOf(data.length) + " bytes: " + SPRMatch.bytesToHex(data, new boolean[0]));
                    data = AspiaBot.skipSize(data);
                    if (AspiaBot.var128Decode(data) > 0L) {
                        ServerHello serverHello = ServerHello.parseFrom(data);
                        serverEncryption = serverHello.getEncryption();
                        AspiaBot.debugPrintLn("Encryption method: " + (Object)((Object)serverEncryption));
                    } else {
                        System.out.print("<!> ServerHello protobuf error.");
                        alwaysFine = false;
                    }
                } else {
                    System.out.print("<!> ServerHello error.");
                    alwaysFine = false;
                }
            }
            if (alwaysFine) {
                SrpIdentify srpIdentify = SrpIdentify.newBuilder().setUsername(aspiaUser).build();
                byte[] srpIdentifyDATA = AspiaBot.addSize(srpIdentify.toByteArray());
                AspiaBot.debugPrintLn("\n--->>> #2 Sent [SrpIdentify] " + String.valueOf(srpIdentifyDATA.length) + " bytes: " + SPRMatch.bytesToHex(srpIdentifyDATA, new boolean[0]) + "\n");
                out.write(srpIdentifyDATA);
                out.flush();
            }
            if (alwaysFine) {
                data = AspiaBot.read(in);
                if (data.length > 0) {
                    AspiaBot.debugPrintLn("<<<--- Received " + String.valueOf(data.length) + " bytes: " + SPRMatch.bytesToHex(data, new boolean[0]));
                    if (AspiaBot.var128Decode(data) > 0L) {
                        data = AspiaBot.skipSize(data);
                        SrpServerKeyExchange srpServerKeyExchange = SrpServerKeyExchange.parseFrom(data);
                        AspiaBot.debugPrintLn("Srv number  = " + SPRMatch.bytesToHex(srpServerKeyExchange.getNumber().toByteArray(), new boolean[0]));
                        AspiaBot.debugPrintLn("Srv gen     = " + SPRMatch.bytesToHex(srpServerKeyExchange.getGenerator().toByteArray(), new boolean[0]));
                        AspiaBot.debugPrintLn("Srv salt    = " + SPRMatch.bytesToHex(srpServerKeyExchange.getSalt().toByteArray(), new boolean[0]));
                        AspiaBot.debugPrintLn("Srv B       = " + SPRMatch.bytesToHex(srpServerKeyExchange.getB().toByteArray(), new boolean[0]));
                        AspiaBot.debugPrintLn("Srv iv      = " + SPRMatch.bytesToHex(srpServerKeyExchange.getIv().toByteArray(), new boolean[0]));
                        sprEngine = new SPREngine(aspiaUser, aspiaPassword, serverEncryption, srpServerKeyExchange.getNumber().toByteArray(), srpServerKeyExchange.getGenerator().toByteArray(), srpServerKeyExchange.getSalt().toByteArray(), srpServerKeyExchange.getB().toByteArray(), srpServerKeyExchange.getIv().toByteArray());
                        AspiaBot.debugPrintLn("String number = \"" + SPRMatch.bytesToHex(srpServerKeyExchange.getNumber().toByteArray(), new boolean[0]) + "\"");
                        AspiaBot.debugPrintLn("String gen    = \"" + SPRMatch.bytesToHex(srpServerKeyExchange.getGenerator().toByteArray(), new boolean[0]) + "\"");
                        AspiaBot.debugPrintLn("String salt   = \"" + SPRMatch.bytesToHex(srpServerKeyExchange.getSalt().toByteArray(), new boolean[0]) + "\"");
                        AspiaBot.debugPrintLn("String B      = \"" + SPRMatch.bytesToHex(srpServerKeyExchange.getB().toByteArray(), new boolean[0]) + "\"");
                        AspiaBot.debugPrintLn("String iv     = \"" + SPRMatch.bytesToHex(srpServerKeyExchange.getIv().toByteArray(), new boolean[0]) + "\"");
                    } else {
                        System.out.print("<!> SprServerKeyExchange protobuf error.");
                        alwaysFine = false;
                    }
                } else {
                    System.out.print("<!> SprServerKeyExchange error.");
                    alwaysFine = false;
                }
            }
            if (alwaysFine && sprEngine != null) {
                SrpClientKeyExchange srpClientKeyExchange = SrpClientKeyExchange.newBuilder().setA(ByteString.copyFrom((byte[])sprEngine.getA())).setIv(ByteString.copyFrom((byte[])sprEngine.getIV())).build();
                byte[] srpClientKeyExchangeDATA = AspiaBot.addSize(srpClientKeyExchange.toByteArray());
                AspiaBot.debugPrintLn("\n--->>> Sent #3 [SrpClientKeyExchange] " + String.valueOf(srpClientKeyExchangeDATA.length) + " bytes: " + SPRMatch.bytesToHex(srpClientKeyExchangeDATA, new boolean[0]) + "\n");
                out.write(srpClientKeyExchangeDATA);
                out.flush();
            }
            if (alwaysFine && sprEngine != null) {
                data = AspiaBot.read(in);
                if (data.length > 0) {
                    AspiaBot.debugPrintLn("<<<--- Received " + String.valueOf(data.length) + " bytes: " + SPRMatch.bytesToHex(data, new boolean[0]));
                    if (AspiaBot.var128Decode(data) > 0L) {
                        data = AspiaBot.skipSize(data);
                        AspiaBot.debugPrintLn("DATA = " + SPRMatch.bytesToHex(data, new boolean[0]));
                        AspiaBot.debugPrintLn("");
                        SessionChallenge sessionChallenge = SessionChallenge.parseFrom(sprEngine.decrypt(data));
                        Version aspiaVersion = sessionChallenge.getVersion();
                        JSONObject row = new JSONObject();
                        row.put("version", (Object)(aspiaVersion.getMajor() + "." + aspiaVersion.getMinor() + "." + aspiaVersion.getPatch() + " Rev.: " + aspiaVersion.getRevision()));
                        row.put("sessions", sessionChallenge.getSessionTypes());
                        row.put("cores", (Object)sessionChallenge.getCpuCores());
                        row.put("os", (Object)sessionChallenge.getOsName());
                        row.put("name", (Object)sessionChallenge.getComputerName());
                        table.append("router", (Object)row);
                        AspiaBot.debugPrintLn("Aspia       = " + aspiaVersion.getMajor() + "." + aspiaVersion.getMinor() + "." + aspiaVersion.getPatch() + " Rev.: " + aspiaVersion.getRevision());
                        AspiaBot.debugPrintLn("Sessions    = " + sessionChallenge.getSessionTypes());
                        AspiaBot.debugPrintLn("CPU cores   = " + sessionChallenge.getCpuCores());
                        AspiaBot.debugPrintLn("OS name     = " + sessionChallenge.getOsName());
                        AspiaBot.debugPrintLn("Computer name  = " + sessionChallenge.getComputerName());
                        if ((sessionChallenge.getSessionTypes() & 1) != 1) {
                            System.out.print("<!> Requested ROUTER_SESSION_ADMIN mode is unsupported by host.");
                            alwaysFine = false;
                        }
                    } else {
                        System.out.print("<!> SessionChallenge protobuf error.");
                        alwaysFine = false;
                    }
                } else {
                    System.out.print("<!> SessionChallenge error.");
                    alwaysFine = false;
                }
            }
            if (alwaysFine && sprEngine != null) {
                Version aspiaBotVersion = Version.newBuilder().setMajor(1).setMinor(2).setPatch(0).setRevision(0).build();
                SessionResponse sessionResponse = SessionResponse.newBuilder().setSessionType(1).setVersion(aspiaBotVersion).setCpuCores(1).setOsName(abOS).setComputerName(abName).build();
                byte[] sessionResponseDATA = AspiaBot.addSize(sprEngine.encrypt(sessionResponse.toByteArray()));
                AspiaBot.debugPrintLn("\n--->>> Sent #4 [SessionResponse] " + String.valueOf(sessionResponseDATA.length) + " bytes: " + SPRMatch.bytesToHex(sessionResponseDATA, new boolean[0]) + "\n");
                out.write(sessionResponseDATA);
                out.flush();
            }
            if (alwaysFine && sprEngine != null) {
                SessionListRequest sessionListRequest = SessionListRequest.newBuilder().setDummy(1L).build();
                AdminToRouter adminToRouter_SessionListRequest = AdminToRouter.newBuilder().setSessionListRequest(sessionListRequest).build();
                byte[] adminToRouter_SessionListRequestDATA = AspiaBot.addSize(sprEngine.encrypt(adminToRouter_SessionListRequest.toByteArray()));
                AspiaBot.debugPrintLn("\n--->>> Sent #5 [AdminToRouter->SessionListRequest] " + String.valueOf(adminToRouter_SessionListRequestDATA.length) + " bytes: " + SPRMatch.bytesToHex(adminToRouter_SessionListRequestDATA, new boolean[0]) + "\n");
                out.write(adminToRouter_SessionListRequestDATA);
                out.flush();
            }
            if (alwaysFine && sprEngine != null) {
                data = AspiaBot.read(in);
                if (data.length > 0) {
                    AspiaBot.debugPrintLn("<<<--- Received " + String.valueOf(data.length) + " bytes: " + SPRMatch.bytesToHex(data, new boolean[0]));
                    if (AspiaBot.var128Decode(data) > 0L) {
                        data = AspiaBot.skipSize(data);
                        AspiaBot.debugPrintLn("DATA = " + SPRMatch.bytesToHex(data, new boolean[0]));
                        AspiaBot.debugPrintLn("");
                        RouterToAdmin routerToAdmin = RouterToAdmin.parseFrom(sprEngine.decrypt(data));
                        SessionList sessionList = routerToAdmin.getSessionList();
                        if (sessionList.getErrorCodeValue() == 0 && requestedId == 0L) {
                            int sessionCount = sessionList.getSessionCount();
                            AspiaBot.debugPrintLn("SessionCount = " + sessionCount);
                            if (requestedId == 0L && !debug) {
                                System.out.println("");
                                System.out.println("+------+----------------------+-----------------+---------------------+----------------------------------------+");
                                System.out.println("|  ID  | ASPIA HOST           |   IP ADDRESS    |      HOST NAME      |     OPERATION SYSTEM                   |");
                                System.out.println("+------+----------------------+-----------------+---------------------+----------------------------------------+");
                            }
                            for (Session session : sessionList.getSessionList()) {
                                HostSessionData hostSessinData = HostSessionData.parseFrom(session.getSessionData());
                                if (session.getSessionTypeValue() != 4) continue;
                                for (int inc = 0; inc < hostSessinData.getHostIdCount(); ++inc) {
                                    AspiaBot.debugPrintLn(session.getSessionId() + "/" + hostSessinData.getHostId(inc) + " \t " + session.getIpAddress() + " \t " + session.getComputerName() + " \t " + session.getOsName());
                                    if (requestedId == 0L && requestedId == 0L) {
                                        JSONObject row = new JSONObject();
                                        row.put("id", hostSessinData.getHostId(inc));
                                        row.put("version", (Object)(session.getVersion().getMajor() + "." + session.getVersion().getMinor() + "." + session.getVersion().getPatch() + " Rev.: " + session.getVersion().getRevision()));
                                        row.put("ip", (Object)session.getIpAddress());
                                        row.put("name", (Object)session.getComputerName());
                                        row.put("os", (Object)session.getOsName());
                                        table.append("hosts", (Object)row);
                                        System.out.println("| " + String.format("%4s", hostSessinData.getHostId(inc)) + " | " + String.format("%-20s", session.getVersion().getMajor() + "." + session.getVersion().getMinor() + "." + session.getVersion().getPatch() + " Rev.: " + session.getVersion().getRevision()) + " | " + String.format("%15s", session.getIpAddress()) + " | " + String.format("%-19s", session.getComputerName()) + " | " + String.format("%-38s", session.getOsName()) + " | ");
                                        System.out.println("+------+----------------------+-----------------+---------------------+----------------------------------------+");
                                    }
                                    hostInfoList.add(new HostInfo(hostSessinData.getHostId(inc), session.getSessionId(), session.getIpAddress(), session.getComputerName(), session.getOsName()));
                                }
                            }
                        }
                    } else {
                        System.out.print("<!> RouterToAdmin protobuf error.");
                        alwaysFine = false;
                    }
                } else {
                    System.out.print("<!> RouterToAdmin error.");
                    alwaysFine = false;
                }
            }
            in.close();
            out.close();
            socket.close();
            int exitCode = 0;
            List<Object> buffer = new ArrayList();
            ArrayList<String> hostsLinesNew = new ArrayList<String>();
            HashMap<Long, String> hostMemoMap = new HashMap<Long, String>();
            if (hostInfoList.size() > 0) {
                if (hosts != null) {
                    PrintWriter hostFileWriter;
                    if (memo != null && memo.indexOf(";") > 0) {
                        String[] records = memo.split(";");
                        for (String string : records) {
                            String[] tmpRec;
                            if (string.indexOf(":") <= 0 || (tmpRec = string.split(":")).length != 2) continue;
                            hostMemoMap.put(Long.parseLong(tmpRec[0]), tmpRec[1]);
                        }
                    }
                    boolean uft8File = false;
                    Path path = Paths.get(hosts, new String[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        uft8File = AspiaBot.isContain_UTF8_BOM(path);
                        if (uft8File) {
                            buffer = Files.readAllLines(path, StandardCharsets.UTF_8);
                            if (((String)buffer.get(0)).length() > 1) {
                                buffer.set(0, ((String)buffer.get(0)).substring(1));
                            }
                        } else {
                            buffer = Files.readAllLines(path, StandardCharsets.US_ASCII);
                        }
                    }
                    for (HostInfo host : hostInfoList) {
                        boolean bl = false;
                        boolean memoFound = false;
                        String dnsName = host.getHostId() + domain + ".aspia.local";
                        String dnsNameMemo = null;
                        String nowJp = new SimpleDateFormat("yyyy-MM-dd HH:mm Z").format(new Date());
                        String comment = "Aspia host ID:" + host.getHostId() + "; " + host.getName() + "; " + host.getOs() + "; " + nowJp + ";";
                        for (int inc = 0; inc < buffer.size(); ++inc) {
                            if (((String)buffer.get(inc)).trim().toLowerCase().contains(" " + dnsName.toLowerCase()) || ((String)buffer.get(inc)).trim().toLowerCase().contains("\t" + dnsName.toLowerCase())) {
                                bl = true;
                                if (!((String)buffer.get(inc)).trim().substring(0, ((String)buffer.get(inc)).trim().toLowerCase().indexOf(dnsName.toLowerCase()) - 1).trim().equals(host.getIp())) {
                                    buffer.set(inc, host.getIp() + " " + dnsName + " # " + comment);
                                }
                            }
                            if (hostMemoMap.size() <= 0 || !hostMemoMap.containsKey(host.getHostId())) continue;
                            dnsNameMemo = (String)hostMemoMap.get(host.getHostId()) + domain + ".aspia.local";
                            if (!((String)buffer.get(inc)).trim().toLowerCase().contains(" " + dnsNameMemo.toLowerCase()) && !((String)buffer.get(inc)).trim().toLowerCase().contains("\t" + dnsNameMemo.toLowerCase())) continue;
                            memoFound = true;
                            if (((String)buffer.get(inc)).trim().substring(0, ((String)buffer.get(inc)).trim().toLowerCase().indexOf(dnsNameMemo.toLowerCase()) - 1).trim().equals(host.getIp())) continue;
                            buffer.set(inc, host.getIp() + " " + dnsNameMemo + " # " + comment);
                        }
                        if (!bl) {
                            hostsLinesNew.add(host.getIp() + " " + dnsName + " # " + comment);
                        }
                        if (memoFound || dnsNameMemo == null) continue;
                        hostsLinesNew.add(host.getIp() + " " + dnsNameMemo + " # " + comment);
                    }
                    if (uft8File) {
                        hostFileWriter = new PrintWriter(hosts, "UTF-8");
                        hostFileWriter.write(65279);
                    } else {
                        hostFileWriter = new PrintWriter(hosts, "US-ASCII");
                    }
                    for (String string : buffer) {
                        hostFileWriter.println(string);
                    }
                    for (String string : hostsLinesNew) {
                        hostFileWriter.println(string);
                    }
                    hostFileWriter.close();
                }
                if (aspiaJson != null) {
                    PrintWriter jsonFileWriter = new PrintWriter(aspiaJson, "UTF-8");
                    jsonFileWriter.write(65279);
                    jsonFileWriter.println(table);
                    jsonFileWriter.close();
                }
            }
            for (HostInfo host : hostInfoList) {
                if (requestedId <= 0L || host.getHostId() != requestedId) continue;
                System.out.println(host.getIp());
                break;
            }
            System.exit(exitCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(-1);
    }

    private static byte[] addSize(byte[] value) {
        byte[] newBuffer = null;
        if (value.length > 0) {
            int var128Size = AspiaBot.var128Size(value.length);
            newBuffer = new byte[value.length + var128Size];
            System.arraycopy(AspiaBot.var128Encode(value.length), 0, newBuffer, 0, var128Size);
            System.arraycopy(value, 0, newBuffer, var128Size, value.length);
        }
        return newBuffer;
    }

    private static byte[] skipSize(byte[] value) {
        byte[] newBuffer = null;
        if (value.length > 0) {
            int msgLen = (int)AspiaBot.var128Decode(value);
            newBuffer = new byte[msgLen];
            System.arraycopy(value, AspiaBot.var128Size(msgLen), newBuffer, 0, msgLen);
        }
        return newBuffer;
    }

    private static byte[] var128Encode(long x) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[AspiaBot.var128Size(x)]);
        while (Long.compareUnsigned(x, 127L) > 0) {
            bb.put((byte)(x & 0x7FL | 0x80L));
            x >>>= 7;
        }
        bb.put((byte)(x & 0x7FL));
        return bb.array();
    }

    private static long var128Decode(byte[] buffer) {
        long b;
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        long x = 0L;
        int shift = 0;
        do {
            b = bb.get() & 0xFF;
            x |= (b & 0x7FL) << shift;
            shift += 7;
        } while ((b & 0x80L) != 0L);
        return x;
    }

    private static int var128Size(long x) {
        int size = 1;
        while (Long.compareUnsigned(x, 127L) > 0) {
            ++size;
            x >>>= 7;
        }
        return size;
    }

    private static byte[] concatenate(byte[] first, byte[] second, int length) {
        byte[] combined = new byte[first.length + length];
        if (first.length > 0) {
            System.arraycopy(first, 0, combined, 0, first.length);
        }
        if (second.length > 0) {
            System.arraycopy(second, 0, combined, first.length, length);
        }
        return combined;
    }

    private static byte[] read(BufferedInputStream in) throws IOException, InterruptedException {
        int termLength = 0;
        byte[] buffer = new byte[]{};
        byte[] term = new byte[16384];
        do {
            termLength = in.read(term, 0, 16384);
            buffer = AspiaBot.concatenate(buffer, term, termLength);
            Thread.sleep(100L);
        } while (in.available() > 0);
        return buffer;
    }

    public static void printFullJVMInfo() throws UnknownHostException {
        System.out.println("");
        System.out.println("Java Runtime Environment version: " + System.getProperty("java.version"));
        System.out.println("Java Runtime Environment version date: " + System.getProperty("java.version.date"));
        System.out.println("Java Runtime Environment vendor: " + System.getProperty("java.vendor"));
        System.out.println("Java vendor URL: " + System.getProperty("java.vendor.url"));
        System.out.println("Java vendor version: " + System.getProperty("java.vendor.version"));
        System.out.println("Java installation directory: " + System.getProperty("java.home"));
        System.out.println("Java Virtual Machine specification version: " + System.getProperty("java.vm.specification.version"));
        System.out.println("Java Virtual Machine specification vendor: " + System.getProperty("java.vm.specification.vendor"));
        System.out.println("Java Virtual Machine specification name: " + System.getProperty("java.vm.specification.name"));
        System.out.println("Java Virtual Machine implementation version: " + System.getProperty("java.vm.version"));
        System.out.println("Java Virtual Machine implementation vendor: " + System.getProperty("java.vm.vendor"));
        System.out.println("Java Virtual Machine implementation name: " + System.getProperty("java.vm.name"));
        System.out.println("Java Runtime Environment specification version: " + System.getProperty("java.specification.version"));
        System.out.println("Java Runtime Environment specification vendor: " + System.getProperty("java.specification.vendor"));
        System.out.println("Java Runtime Environment specification name: " + System.getProperty("java.specification.name"));
        System.out.println("Java class format version number: " + System.getProperty("java.class.version"));
        System.out.println("Java class path: " + System.getProperty("java.class.path"));
        System.out.println("List of paths to search when loading libraries: " + System.getProperty("java.library.path"));
        System.out.println("Default temp file path: " + System.getProperty("java.io.tmpdir"));
        System.out.println("Name of JIT compiler to use: " + System.getProperty("java.compiler"));
        System.out.println("Host name: " + InetAddress.getLocalHost().getHostName());
        System.out.println("Operating system name: " + System.getProperty("os.name"));
        System.out.println("Operating system architecture: " + System.getProperty("os.arch"));
        System.out.println("Operating system version: " + System.getProperty("os.version"));
        System.out.println("File separator: " + System.getProperty("file.separator"));
        System.out.println("Path separator: " + System.getProperty("path.separator"));
        System.out.println("Line separator: " + System.getProperty("line.separator"));
        System.out.println("User's account name: " + System.getProperty("user.name"));
        System.out.println("User's home directory: " + System.getProperty("user.home"));
        System.out.println("User's current working directory: " + System.getProperty("user.dir"));
        System.out.println("");
    }

    private static void debugPrintLn(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    private static boolean isContain_UTF8_BOM(Path path) {
        boolean result = false;
        byte[] bom = new byte[3];
        try (FileInputStream is = new FileInputStream(path.toFile());){
            ((InputStream)is).read(bom);
            String content = new String(SPRMatch.bytesToHex(bom, new boolean[0]));
            if ("efbbbf".equalsIgnoreCase(content)) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void setID(long value) {
        requestedId = value;
    }

    public static void setSilent(boolean value) {
        silent = value;
    }

    public static void setDebug(boolean value) {
        debug = value;
    }

    public static void setJVMInfo(boolean value) {
        printJVMInfo = value;
    }

    public static void setHosts(String value) {
        hosts = value;
    }

    public static void setDomain(String value) {
        domain = "." + value;
    }

    public static void setMemo(String value) {
        memo = value;
    }

    public static void setAddress(String value) {
        aspiaPort = 8060;
        if (value.indexOf(":") > 0) {
            String[] newUrl = value.split(":");
            aspiaURL = newUrl[0];
            aspiaPort = Integer.valueOf(newUrl[1]);
        } else {
            aspiaURL = value;
        }
    }

    public static void setUser(String value) {
        aspiaUser = value;
    }

    public static void setPassword(String value) {
        aspiaPassword = value;
    }

    public static void setTimeout(int value) {
        socketTimeout = value * 1000;
    }

    public static void setJsonFile(String value) {
        aspiaJson = value;
    }

    public static void printVersion() {
        System.out.println(abName + " v." + 1 + "." + 2 + "." + 0);
        System.out.println(abCopyright);
        System.out.println("");
        if (System.getProperty("java.vendor").length() > 0 && System.getProperty("java.version").length() > 0) {
            System.out.println("JavaVM version: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
            if (System.getProperty("os.name").length() > 0 && System.getProperty("os.arch").length() > 0) {
                System.out.println("Running on " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")");
                abOS = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + "), Java: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version");
            }
        }
    }

    public static Future<Boolean> portIsOpen(ExecutorService es, final String ip, final int port, final int timeout) {
        return es.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    Socket socket = new Socket();
                    socket.connect(new InetSocketAddress(ip, port), timeout);
                    socket.close();
                    System.out.print("+");
                    return true;
                }
                catch (Exception ex) {
                    System.out.print(".");
                    return false;
                }
            }
        });
    }

    public static String getConsoleEncoding() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> stdOutClass = System.out.getClass();
        Field charOutField = stdOutClass.getDeclaredField("charOut");
        charOutField.setAccessible(true);
        OutputStreamWriter o = (OutputStreamWriter)charOutField.get(System.out);
        return o.getEncoding();
    }

    static class HostInfo {
        private long host_id;
        private long session_id;
        private String ip;
        private String name;
        private String os;

        public HostInfo(long host_id, long session_id, String ip, String name, String os) {
            this.host_id = host_id;
            this.session_id = session_id;
            this.ip = ip;
            this.name = name;
            this.os = os;
        }

        public long getHostId() {
            return this.host_id;
        }

        public long getSessionId() {
            return this.session_id;
        }

        public String getIp() {
            return this.ip;
        }

        public String getName() {
            return this.name;
        }

        public String getOs() {
            return this.os;
        }
    }
}

