/*
 * Decompiled with CFR 0.152.
 */
package info.malenkov.aspiabot;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.bouncycastle.jcajce.provider.digest.Blake2b;
import org.bouncycastle.jcajce.provider.digest.Blake2s;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class SPRMatch {
    public static String bytesToHex(byte[] bytes, boolean ... toUpper) {
        char[] HEX_ARRAY = "0123456789abcdef".toCharArray();
        boolean convert2Upper = toUpper.length >= 1 ? toUpper[0] : false;
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        if (convert2Upper) {
            return new String(hexChars).toUpperCase();
        }
        return new String(hexChars);
    }

    static BigInteger RAND(int len, SecureRandom random) {
        return BigIntegers.createRandomBigInteger((int)len, (SecureRandom)random);
    }

    static byte[] HS2BA(String data) {
        return Hex.decode((String)data);
    }

    static String BA2HS(byte[] bytes, boolean ... toUpper) {
        boolean convert2Upper;
        boolean bl = convert2Upper = toUpper.length >= 1 ? toUpper[0] : false;
        if (convert2Upper) {
            return Hex.toHexString((byte[])bytes).toUpperCase();
        }
        return Hex.toHexString((byte[])bytes);
    }

    static byte[] BI2BA(BigInteger value) {
        return BigIntegers.asUnsignedByteArray((BigInteger)value);
    }

    static byte[] BI2BA(BigInteger value, int minLen) {
        return SPRMatch.zeroFill(BigIntegers.asUnsignedByteArray((BigInteger)value), minLen);
    }

    static BigInteger BA2BI(byte[] data) {
        return BigIntegers.fromUnsignedByteArray((byte[])data);
    }

    static BigInteger hash_BLAKE2s256(BigInteger BN_data) throws NoSuchAlgorithmException {
        Blake2s.Blake2s256 blake2s256 = new Blake2s.Blake2s256();
        blake2s256.update(SPRMatch.BI2BA(BN_data));
        BigInteger result = SPRMatch.BA2BI(blake2s256.digest());
        return result;
    }

    static BigInteger hash_BLAKE2b512(BigInteger BN_data) throws NoSuchAlgorithmException {
        Blake2b.Blake2b512 blake2b512;
        BigInteger result;
        do {
            blake2b512 = new Blake2b.Blake2b512();
            blake2b512.update(SPRMatch.BI2BA(BN_data));
        } while (SPRMatch.BI2BA(result = SPRMatch.BA2BI(blake2b512.digest())).length * 8 != 512);
        return result;
    }

    static BigInteger calc_x(BigInteger BN_s, String str_I, String str_p) throws NoSuchAlgorithmException {
        Blake2b.Blake2b512 blake2b512 = new Blake2b.Blake2b512();
        blake2b512.update(str_I.toLowerCase().getBytes(StandardCharsets.UTF_8), 0, str_I.getBytes(StandardCharsets.UTF_8).length);
        blake2b512.update(":".getBytes(StandardCharsets.UTF_8), 0, ":".getBytes(StandardCharsets.UTF_8).length);
        blake2b512.update(str_p.getBytes(StandardCharsets.UTF_8), 0, str_p.getBytes(StandardCharsets.UTF_8).length);
        Blake2b.Blake2b512 blake2b512bis = new Blake2b.Blake2b512();
        blake2b512bis.update(SPRMatch.BI2BA(BN_s));
        blake2b512bis.update(blake2b512.digest());
        return SPRMatch.BA2BI(blake2b512bis.digest());
    }

    static BigInteger calc_xy(BigInteger BN_x, BigInteger BN_y, BigInteger BN_N) throws NoSuchAlgorithmException {
        int N_bytes = SPRMatch.BI2BA(BN_N).length;
        byte[] xy = new byte[N_bytes + N_bytes];
        java.util.Arrays.fill(xy, (byte)0);
        System.arraycopy(SPRMatch.BI2BA(BN_x), 0, xy, 0, SPRMatch.BI2BA(BN_x).length);
        System.arraycopy(SPRMatch.BI2BA(BN_y), 0, xy, N_bytes + N_bytes - SPRMatch.BI2BA(BN_y).length, SPRMatch.BI2BA(BN_y).length);
        Blake2b.Blake2b512 blake2b512 = new Blake2b.Blake2b512();
        blake2b512.update(xy);
        return SPRMatch.BA2BI(blake2b512.digest());
    }

    static BigInteger calc_u(BigInteger BN_A, BigInteger BN_B, BigInteger BN_N) throws NoSuchAlgorithmException {
        return SPRMatch.calc_xy(BN_A, BN_B, BN_N);
    }

    static BigInteger calc_k(BigInteger BN_N, BigInteger BN_g) throws NoSuchAlgorithmException {
        return SPRMatch.calc_xy(BN_N, BN_g, BN_N);
    }

    static BigInteger calc_A(BigInteger BN_a, BigInteger BN_N, BigInteger BN_g) throws NoSuchAlgorithmException {
        BigInteger BN_A = BN_g.modPow(BN_a, BN_N);
        return BN_A;
    }

    static BigInteger calc_B(BigInteger BN_b, BigInteger BN_N, BigInteger BN_g, BigInteger BN_v) throws NoSuchAlgorithmException {
        BigInteger BN_gb = BN_g.modPow(BN_b, BN_N);
        BigInteger BN_k = SPRMatch.calc_k(BN_N, BN_g);
        BigInteger BN_kv = BN_k.multiply(BN_v).mod(BN_N);
        BigInteger BN_B = BN_gb.add(BN_kv).mod(BN_N);
        return BN_B;
    }

    static BigInteger calcServerKey(BigInteger BN_A, BigInteger BN_v, BigInteger BN_u, BigInteger BN_b, BigInteger BN_N) {
        BigInteger tmp = BN_v.modPow(BN_u, BN_N);
        tmp = BN_A.multiply(tmp).mod(BN_N);
        BigInteger BN_S = tmp.modPow(BN_b, BN_N);
        return BN_S;
    }

    static BigInteger calcClientKey(BigInteger BN_N, BigInteger BN_B, BigInteger BN_g, BigInteger BN_x, BigInteger BN_a, BigInteger BN_u) throws NoSuchAlgorithmException {
        BigInteger BN_k = SPRMatch.calc_k(BN_N, BN_g);
        BigInteger tmp = BN_g.modPow(BN_x, BN_N);
        BigInteger tmp2 = tmp.multiply(BN_k).mod(BN_N);
        tmp = BN_B.subtract(tmp2).mod(BN_N);
        BigInteger tmp3 = BN_u.multiply(BN_x);
        tmp2 = BN_a.add(tmp3);
        BigInteger BN_K = tmp.modPow(tmp2, BN_N);
        return BN_K;
    }

    static boolean verify_B_mod_N(BigInteger BN_B, BigInteger BN_N) {
        return !BN_B.mod(BN_N).equals(0);
    }

    static BigInteger calc_v(String str_I, String str_p, BigInteger BN_s, BigInteger BN_N, BigInteger BN_g) throws NoSuchAlgorithmException {
        BigInteger BN_x = SPRMatch.calc_x(BN_s, str_I, str_p);
        return BN_g.modPow(BN_x, BN_N);
    }

    static BigInteger increment(BigInteger integer) {
        return SPRMatch.add(integer == null ? BigInteger.ZERO : integer, BigInteger.ONE);
    }

    private static BigInteger add(BigInteger ... operands) {
        BigInteger result = null;
        if (operands != null) {
            for (BigInteger operand : operands) {
                if (operand == null) continue;
                result = result == null ? operand : result.add(operand);
            }
        }
        return result;
    }

    private static byte[] zeroFill(byte[] srcData, int len) {
        byte[] prefix = null;
        if (srcData.length < len) {
            prefix = new byte[len - srcData.length];
        }
        return Arrays.concatenate(prefix, (byte[])srcData);
    }
}

