/*
 * Decompiled with CFR 0.152.
 */
package info.malenkov;

import info.malenkov.CommandLineParcer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FB2mv {
    private static final String VERSION = "1.1";
    private static boolean DEBUG = false;
    private static final String CLK_DBG = "--debug";
    private static final String CLK_DBG_S = "-@";
    private static final String CLK_DIR = "--dir";
    private static final String CLK_DIR_S = "-d";
    private static final String CLK_FILE = "--file";
    private static final String CLK_FILE_S = "-f";
    private static final String CLK_LIST = "--list";
    private static final String CLK_LIST_S = "-l";
    private static final String CLK_MASK = "--mask";
    private static final String CLK_MASK_S = "-m";
    private static final String CLK_REST = "--restricted";
    private static final String CLK_REST_S = "-x";
    private static final String CLK_STUB = "--stub";
    private static final String CLK_STUB_S = "-s";
    private static final String CLK_ENC = "--encoding";
    private static final String CLK_ENC_S = "-e";
    private static final String CLK_HELP = "--help";
    private static final String CLK_HELP_S = "-h";
    private static final String CLK_SUBD = "--recursive";
    private static final String CLK_SUBD_S = "-r";
    private static final String CLK_JAVA = "--java";
    private static final String CLK_JAVA_S = "-j";
    private static final String CLK_VER = "--version";
    private static final String CLK_VER_S = "-v";
    private static final String CLK_UNZ = "--unzip";
    private static final String CLK_UNZ_S = "-u";
    private static final String CLK_REV = "--reverce";
    private static final String CLK_REV_S = "-z";
    private static String[] commandLineKeys = new String[]{"--debug", "-@", "--dir", "-d", "--file", "-f", "--list", "-l", "--mask", "-m", "--restricted", "-x", "--stub", "-s", "--encoding", "-e", "--recursive", "-r", "--version", "-v", "--java", "-j", "--help", "-h", "--unzip", "-u", "--reverce", "-z"};
    private static CommandLineParcer commandLineParcer;
    private static String booksFolder;
    private static String fileFB2;
    private static String fileMask;
    private static String restrictedCharacters;
    private static String replaceCharacter;
    private static String defaultZIPFilenameEncoding;
    private static boolean listOnly;
    private static boolean recursiveScan;
    private static boolean unzip;
    private static boolean reverce;
    private static Engine engine;

    public static void main(String[] stringArray) {
        commandLineParcer = new CommandLineParcer(stringArray, commandLineKeys);
        if (commandLineParcer.isKeyExist(CLK_DBG_S) || commandLineParcer.isKeyExist(CLK_DBG)) {
            DEBUG = true;
        }
        if (commandLineParcer.getKeysCount() == 0) {
            FB2mv.help();
        } else if (commandLineParcer.getUnknownKeysCount() > 0) {
            System.out.println("fb2mv error: Unknown key(s) found: " + Arrays.toString(commandLineParcer.getUnknownKeys()));
            System.out.println(commandLineParcer.getKeyValue(CLK_DIR_S));
        } else if (commandLineParcer.isKeyExist(CLK_HELP_S) || commandLineParcer.isKeyExist(CLK_HELP)) {
            FB2mv.help();
        } else if (commandLineParcer.isKeyExist(CLK_VER_S) || commandLineParcer.isKeyExist(CLK_VER)) {
            FB2mv.version();
        } else if (commandLineParcer.isKeyExist(CLK_JAVA_S) || commandLineParcer.isKeyExist(CLK_JAVA)) {
            FB2mv.printEnvironment();
        } else if (!(commandLineParcer.isKeyExist(CLK_DIR_S) || commandLineParcer.isKeyExist(CLK_DIR) || commandLineParcer.isKeyExist(CLK_FILE_S) || commandLineParcer.isKeyExist(CLK_FILE))) {
            System.out.println("fb2mv error: Missing required argument --dir=<folder_name> or --file=<file_name>");
        } else {
            if (commandLineParcer.isKeyExist(CLK_DIR_S)) {
                booksFolder = commandLineParcer.getKeyValue(CLK_DIR_S);
            }
            if (commandLineParcer.isKeyExist(CLK_DIR)) {
                booksFolder = commandLineParcer.getKeyValue(CLK_DIR);
            }
            if (commandLineParcer.isKeyExist(CLK_FILE_S)) {
                fileFB2 = commandLineParcer.getKeyValue(CLK_FILE_S);
            }
            if (commandLineParcer.isKeyExist(CLK_FILE)) {
                fileFB2 = commandLineParcer.getKeyValue(CLK_FILE);
            }
            if (commandLineParcer.isKeyExist(CLK_ENC_S)) {
                defaultZIPFilenameEncoding = commandLineParcer.getKeyValue(CLK_ENC_S);
            }
            if (commandLineParcer.isKeyExist(CLK_ENC)) {
                defaultZIPFilenameEncoding = commandLineParcer.getKeyValue(CLK_ENC);
            }
            if (commandLineParcer.isKeyExist(CLK_MASK_S)) {
                fileMask = commandLineParcer.getKeyValue(CLK_MASK_S);
            }
            if (commandLineParcer.isKeyExist(CLK_MASK)) {
                fileMask = commandLineParcer.getKeyValue(CLK_MASK);
            }
            if (commandLineParcer.isKeyExist(CLK_STUB_S)) {
                replaceCharacter = commandLineParcer.getKeyValue(CLK_STUB_S);
            }
            if (commandLineParcer.isKeyExist(CLK_STUB)) {
                replaceCharacter = commandLineParcer.getKeyValue(CLK_STUB);
            }
            if (commandLineParcer.isKeyExist(CLK_REST_S)) {
                restrictedCharacters = commandLineParcer.getKeyValue(CLK_REST_S);
            }
            if (commandLineParcer.isKeyExist(CLK_REST)) {
                restrictedCharacters = commandLineParcer.getKeyValue(CLK_REST);
            }
            if (commandLineParcer.isKeyExist(CLK_SUBD_S) || commandLineParcer.isKeyExist(CLK_SUBD)) {
                recursiveScan = true;
            }
            if (commandLineParcer.isKeyExist(CLK_LIST_S) || commandLineParcer.isKeyExist(CLK_LIST)) {
                listOnly = true;
            }
            if (commandLineParcer.isKeyExist(CLK_UNZ) || commandLineParcer.isKeyExist(CLK_UNZ_S)) {
                unzip = true;
            }
            if (commandLineParcer.isKeyExist(CLK_REV) || commandLineParcer.isKeyExist(CLK_REV_S)) {
                reverce = true;
            }
            if (fileFB2 != null && booksFolder != null) {
                System.out.println("fb2mv error: It is impossible to use keys --file (-f) and --dir (-d) at the same time...");
            } else if (booksFolder != null) {
                Engine engine = new Engine();
                FB2mv.dir(booksFolder, fileMask, engine, recursiveScan);
            } else if (fileFB2 != null) {
                FB2mv.engineFB2(fileFB2, listOnly);
            }
        }
    }

    private static void help() {
        System.out.println("Usage: fb2mv [OPTIONS] DIRECTORY");
        System.out.println("Rename fb2-compatible files to human readable form based on fb2-description information.");
        System.out.println();
        System.out.println("Required arguments: ");
        System.out.println("  -d=<..>, --dir=<..>\t\tprocess directory that contains source fb2-files");
        System.out.println("or ");
        System.out.println("  -f=<..>, --file=<..>\t\tprocess single fb2-file only");
        System.out.println();
        System.out.println("Optional arguments: ");
        System.out.println("  -e=<..>, --encoding=<..>\tzip-file filename encoding ('cp866' is default)");
        System.out.println("  -l, --list\t\t\tpreview mode (no file modification)");
        System.out.println("  -m=<..>, --mask=<..>\t\tfilemask of source fb2-file ('*.fb2.zip' is default)");
        System.out.println("  -r, --recursive\t\tprocess directories recursively");
        System.out.println("  -s=<..>, --stub=<..>\t\tstub-symbol for filename-restricted characters ('~' is default)");
        System.out.println("  -x=<..>, --restricted=<..>\trestricted characters list ('[\\/:*?<>|]+' is default)");
        System.out.println("  -u, --unzip\t\t\tunzip compressed *.fb2.zip to pure *.fb2 (for some sort of e-readers)");
        System.out.println("  -z, --reverce\t\t\treverce new file name upside down (i.e. title-author) ");
        System.out.println();
        System.out.println("  -h, --help\t\t\tdisplay this help and exit");
        System.out.println("  -j, --java\t\t\tprint Java runtime environment and exit");
        System.out.println("  -v, --version\t\t\toutput version information and exit");
        System.out.println();
        System.out.println("Mandatory arguments to long options are mandatory for short options too.");
        System.out.println();
        System.out.println("Usage example (Linux/MacOSX): fb2mv -r -l -d=/home/user/books");
        System.out.println("Usage example (Windows): fb2mv -r -l -d=\"C:\\Documents and Settings\\User\\My Documents\\Books\"");
    }

    private static void version() {
        System.out.println(VERSION);
    }

    private static void printEnvironment() {
        System.out.println("\n--- 8< --- Java runtime environment [begin] --- 8< --- ");
        System.out.println("Java Runtime Environment version: " + System.getProperty("java.version"));
        System.out.println("Java Runtime Environment vendor: " + System.getProperty("java.vendor"));
        System.out.println("Java vendor URL: " + System.getProperty("java.vendor.url"));
        System.out.println("Java installation directory: " + System.getProperty("java.home"));
        System.out.println("Java Virtual Machine specification version: " + System.getProperty("java.vm.specification.version"));
        System.out.println("Java Virtual Machine specification vendor: " + System.getProperty("java.vm.specification.vendor"));
        System.out.println("Java Virtual Machine specification name: " + System.getProperty("java.vm.specification.name"));
        System.out.println("Java Virtual Machine implementation version: " + System.getProperty("java.vm.version"));
        System.out.println("Java Virtual Machine implementation vendor: " + System.getProperty("java.vm.vendor"));
        System.out.println("Java Virtual Machine implementation name: " + System.getProperty("java.vm.name"));
        System.out.println("Java Runtime Environment specification version: " + System.getProperty("java.specification.version"));
        System.out.println("Java Runtime Environment specification vendor: " + System.getProperty("java.specification.vendor"));
        System.out.println("Java Runtime Environment specification name: " + System.getProperty("java.specification.name"));
        System.out.println("Java class format version number: " + System.getProperty("java.class.version"));
        System.out.println("Java class path: " + System.getProperty("java.class.path"));
        System.out.println("List of paths to search when loading libraries: " + System.getProperty("java.library.path"));
        System.out.println("Default temp file path: " + System.getProperty("java.io.tmpdir"));
        System.out.println("Name of JIT compiler to use: " + System.getProperty("java.compiler"));
        System.out.println("Path of extension directory or directories: " + System.getProperty("java.ext.dirs"));
        System.out.println("Operating system name: " + System.getProperty("os.name"));
        System.out.println("Operating system architecture: " + System.getProperty("os.arch"));
        System.out.println("Operating system version: " + System.getProperty("os.version"));
        System.out.println("File separator (\"/\" on UNIX): " + System.getProperty("file.separator"));
        System.out.println("Path separator (\":\" on UNIX): " + System.getProperty("path.separator"));
        System.out.println("User's account name: " + System.getProperty("user.name"));
        System.out.println("User's home directory: " + System.getProperty("user.home"));
        System.out.println("User's current working directory: " + System.getProperty("user.dir"));
        System.out.println("--- 8< --- Java runtime environment [end] --- 8< --- \n");
    }

    public static void engineFB2(String string, boolean bl) {
        Object object;
        Object object2;
        String string2 = System.getProperty("java.io.tmpdir").replace("\\", "/");
        if (string2.charAt(string2.length() - 1) != '/') {
            string2 = string2 + "/";
        }
        String string3 = null;
        String string4 = null;
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "/FictionBook/description/title-info/book-title";
        try {
            object2 = new ZipFile(string);
            ((ZipFile)object2).setFileNameCharset(defaultZIPFilenameEncoding);
            object = ((ZipFile)object2).getFileHeaders();
            if (object.size() > 1) {
                System.out.println("ERROR: Multi-file archives in not supported yet! Sorry...");
            } else {
                for (int i = 0; i < object.size(); ++i) {
                    string4 = ((FileHeader)object.get(i)).getFileName();
                }
            }
        }
        catch (ZipException zipException) {
            zipException.printStackTrace();
        }
        if (string4 != null) {
            try {
                object2 = new ZipFile(string);
                ((ZipFile)object2).setFileNameCharset(defaultZIPFilenameEncoding);
                ((ZipFile)object2).extractFile(string4, string2);
            }
            catch (ZipException zipException) {
                zipException.printStackTrace();
            }
            try {
                Object object3;
                Object object4;
                object2 = ".fb2.zip";
                if (unzip) {
                    object2 = ".fb2";
                }
                object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                String string12 = "file://";
                if (FB2mv.isWindows()) {
                    string12 = string12 + "/";
                }
                if (DEBUG) {
                    System.out.println("> TMP filename: " + string12 + string2 + string4);
                }
                Document document = ((DocumentBuilder)object).parse(string12 + string2 + string4);
                string5 = FB2mv.getXMLValue(document, "/FictionBook/description/title-info/author/first-name");
                string6 = FB2mv.getXMLValue(document, "/FictionBook/description/title-info/author/middle-name");
                string7 = FB2mv.getXMLValue(document, "/FictionBook/description/title-info/author/last-name");
                string10 = FB2mv.getXMLValue(document, string11);
                string8 = FB2mv.getXMLValue(document, "/FictionBook/description/title-info/sequence/@name");
                string9 = FB2mv.getXMLValue(document, "/FictionBook/description/title-info/sequence/@number");
                if (!reverce) {
                    object4 = FB2mv.buildAuthorName(string5, string6, string7);
                    if (((String)object4).length() > 0) {
                        object4 = (String)object4 + " ";
                    }
                    if (((String)(object3 = FB2mv.buildSequence(string8, string9))).length() > 0) {
                        object3 = (String)object3 + " ";
                    }
                    if (string10.length() > 0) {
                        string10 = "'" + string10 + "'";
                    }
                    string3 = ((String)object4 + (String)object3 + string10).replaceAll(restrictedCharacters, replaceCharacter) + (String)object2;
                } else {
                    object4 = FB2mv.buildAuthorName(string5, string6, string7);
                    object3 = FB2mv.buildSequence(string8, string9);
                    if (((String)object3).length() > 0) {
                        object3 = (String)object3 + " ";
                    }
                    if (string10.length() > 0) {
                        string10 = "'" + string10 + "' ";
                    }
                    string3 = (string10 + (String)object3 + (String)object4).replaceAll(restrictedCharacters, replaceCharacter) + (String)object2;
                }
                if (!bl) {
                    if (!reverce) {
                        object4 = new File(string);
                        if (string.contains("/") || string.contains("\\")) {
                            object3 = new File(((File)object4).getParentFile().getAbsolutePath() + "/" + string3);
                            System.out.println(string);
                            System.out.println(((File)object4).getParentFile().getAbsolutePath() + "/" + string3);
                            ((File)object4).renameTo((File)object3);
                        } else {
                            object3 = new File(string3);
                            System.out.println(string);
                            System.out.println(string3);
                            ((File)object4).renameTo((File)object3);
                        }
                    } else {
                        object4 = new File(string);
                        if (string.contains("/") || string.contains("\\")) {
                            object3 = new File(((File)object4).getParentFile().getAbsolutePath() + "/" + string3);
                            System.out.println(string);
                            System.out.println(((File)object4).getParentFile().getAbsolutePath() + "/" + string3);
                            Files.copy(Paths.get(string2 + "/" + string4, new String[0]), Paths.get(((File)object4).getParentFile().getAbsolutePath() + "/" + string3, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            ((File)object4).delete();
                        } else {
                            object3 = new File(string3);
                            System.out.println(string);
                            System.out.println(string3);
                            Files.copy(Paths.get(string2 + "/" + string4, new String[0]), Paths.get(string3, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            ((File)object4).delete();
                        }
                    }
                    System.out.println("Renamed: Ok");
                    System.out.println();
                } else {
                    object4 = new File(string);
                    if (string.contains("/") || string.contains("\\")) {
                        object3 = new File(((File)object4).getParentFile().getAbsolutePath() + "/" + string3);
                        System.out.println(string);
                        System.out.println(((File)object4).getParentFile().getAbsolutePath() + "/" + string3);
                    } else {
                        object3 = new File(string3);
                        System.out.println(string);
                        System.out.println(string3);
                    }
                    System.out.println();
                }
                object4 = new File(string2 + "/" + string4);
                ((File)object4).delete();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace(System.out);
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace(System.out);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
        }
    }

    public static String getXMLValue(Document document, String string) {
        String string2 = "";
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            Node node = (Node)xPath.evaluate(string, document, XPathConstants.NODE);
            if (node != null) {
                string2 = node.getTextContent();
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace(System.out);
        }
        return string2;
    }

    public static String buildAuthorName(String string, String string2, String string3) {
        String string4 = "";
        if (string3.length() > 0) {
            string4 = string3;
            if (string.length() > 0) {
                string4 = string4 + " " + string.substring(0, 1) + ".";
            }
            if (string2.length() > 0) {
                string4 = string4 + string2.substring(0, 1) + ".";
            }
        }
        return string4;
    }

    public static String buildSequence(String string, String string2) {
        String string3 = "";
        if (string.length() > 0) {
            string3 = "[" + string;
            string3 = string2.length() > 0 ? string3 + " #" + string2 + "]" : string3 + "]";
        }
        return string3;
    }

    public static boolean dir(String string, String string2, EngineInterface engineInterface, boolean bl) {
        File file = new File(string);
        Object[] objectArray = file.listFiles();
        boolean bl2 = true;
        Arrays.sort(objectArray);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length && !(((File)objectArray[i]).isDirectory() ? bl && !(bl2 = FB2mv.dir(((File)objectArray[i]).toString(), string2, engineInterface, true)) : !((File)objectArray[i]).isHidden() && FilenameUtils.wildcardMatchOnSystem(((File)objectArray[i]).toString(), string2) && !(bl2 = engineInterface.execute(((File)objectArray[i]).toString(), true))); ++i) {
            }
        }
        return bl2;
    }

    private static boolean isWindows() {
        boolean bl = false;
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            bl = true;
        }
        return bl;
    }

    static {
        booksFolder = null;
        fileFB2 = null;
        fileMask = "*.fb2.zip";
        restrictedCharacters = "[\\/:*?<>|]+";
        replaceCharacter = "~";
        defaultZIPFilenameEncoding = "cp866";
        listOnly = false;
        recursiveScan = false;
        unzip = false;
        reverce = false;
        engine = new Engine();
    }

    public static class Engine
    implements EngineInterface {
        @Override
        public boolean execute(String string, boolean bl) {
            FB2mv.engineFB2(string, listOnly);
            return true;
        }
    }

    public static interface EngineInterface {
        public boolean execute(String var1, boolean var2);
    }
}

