/*
 * Decompiled with CFR 0.152.
 */
package malenkov.maxim.veederroot.ipterminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.net.telnet.TelnetClient;

public final class IPTerminal
implements Runnable {
    static TelnetClient telnetClient = new TelnetClient();
    static String remoteIP = null;
    static int remotePort = 23;
    static int execTimeout = 0;
    static String charsetEncoding = "default";
    static PrintStream printStream;
    static String terminator;
    static String command;
    static String outputFile;
    static String outputBuffer;
    static int multipleTimeout;
    static boolean dataReceived;
    static boolean checkInProgress;

    public static final void main(String[] stringArray) {
        Object object;
        boolean bl = true;
        int n = 0;
        String string = System.getProperty("consoleEncoding");
        String string2 = System.getProperty("consoleEncoding");
        Options options = new Options();
        Option option = Option.builder("s").hasArg(true).longOpt("server").argName("server name or IP address").desc("specifies the hostname or IP address of the remote computer to connect to").build();
        options.addOption(option);
        Option option2 = Option.builder("p").hasArg(true).longOpt("port").argName("port number").desc("specifies a port number or service name").required(false).build();
        options.addOption(option2);
        Option option3 = Option.builder("c").hasArg(true).longOpt("charset").argName("charset-encoding").desc("specifies charset-encoding for console output [ https://docs.oracle.com/javase/8/docs/technotes/guides/intl/encoding.doc.html ]").required(false).build();
        options.addOption(option3);
        Option option4 = Option.builder("x").hasArg(true).longOpt("execute").argName("command string").desc("execute this command after connection established").required(false).build();
        options.addOption(option4);
        Option option5 = Option.builder("t").hasArg(true).longOpt("terminator").argName("terminator string").desc("close current telnet connection immediately after this text has been received").required(false).build();
        options.addOption(option5);
        Option option6 = Option.builder("o").hasArg(true).longOpt("output").argName("output file name").desc("write server response to specified file ($d - current date, $t - current time)").required(false).build();
        options.addOption(option6);
        Option option7 = Option.builder("i").hasArg(true).longOpt("timeout").argName("execution timeout").desc("specify maximum time for program execution (in seconds)").required(false).build();
        options.addOption(option7);
        options.addOption("h", "help", false, "print usage and help information");
        options.addOption("e", "environment", false, "print system environment");
        options.addOption("v", "version", false, "print program's version");
        Option option8 = Option.builder("m").hasArg(true).longOpt("multiple").argName("timeout").desc("specify a timeout value for multiple connection check subroutine").required(false).build();
        options.addOption(option8);
        DefaultParser defaultParser = new DefaultParser();
        try {
            Object object2;
            object = defaultParser.parse(options, stringArray);
            if (((CommandLine)object).hasOption("c")) {
                charsetEncoding = ((CommandLine)object).getOptionValue("c");
            }
            if (((CommandLine)object).hasOption("h")) {
                IPTerminal.printVersion();
                object2 = new HelpFormatter();
                ((HelpFormatter)object2).printHelp("java -jar IPTelnet.jar -s telnet.server.local\n\n", options);
                bl = false;
                n = -1;
            } else {
                if (((CommandLine)object).hasOption("v")) {
                    IPTerminal.printVersion();
                }
                if (((CommandLine)object).hasOption("e")) {
                    IPTerminal.printEnvironment();
                }
                if (((CommandLine)object).hasOption("p")) {
                    remotePort = Integer.parseInt(((CommandLine)object).getOptionValue("p"));
                }
                if (((CommandLine)object).hasOption("x")) {
                    command = String.format(((CommandLine)object).getOptionValue("x"), new Object[0]);
                }
                if (((CommandLine)object).hasOption("t")) {
                    terminator = ((CommandLine)object).getOptionValue("t");
                }
                if (((CommandLine)object).hasOption("i")) {
                    execTimeout = Integer.parseInt(((CommandLine)object).getOptionValue("i"));
                }
                if (((CommandLine)object).hasOption("o")) {
                    outputFile = ((CommandLine)object).getOptionValue("o");
                    outputBuffer = "";
                    object2 = new Date();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd");
                    String string3 = simpleDateFormat.format((Date)object2);
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HHmmssS");
                    String string4 = simpleDateFormat2.format((Date)object2);
                    outputFile = outputFile.replace("$d", string3);
                    outputFile = outputFile.replace("$t", string4);
                }
                if (!((CommandLine)object).hasOption("s")) {
                    System.err.println("Server name or IP address is required!\n");
                    object2 = new HelpFormatter();
                    ((HelpFormatter)object2).printHelp("java -jar IPTelnet.jar -s telnet.server.local\n\n", options);
                    bl = false;
                    n = -1;
                } else {
                    remoteIP = ((CommandLine)object).getOptionValue("s");
                    if (((CommandLine)object).hasOption("m")) {
                        multipleTimeout = Integer.parseInt(((CommandLine)object).getOptionValue("m"));
                    }
                }
            }
            try {
                printStream = new PrintStream((OutputStream)System.out, true, charsetEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println(String.format("Unsupported console charset encoding: %s", unsupportedEncodingException.getMessage()));
                bl = false;
            }
        }
        catch (ParseException parseException) {
            System.err.println(String.format("Unexpected exeption: %s", parseException.getMessage()));
            bl = false;
        }
        if (bl) {
            if (execTimeout > 0) {
                object = new Thread((Runnable)new Watchdog(), "WatchdogThread");
                ((Thread)object).start();
            }
            n = IPTerminal.telnetEngine(remoteIP, remotePort);
        }
        System.exit(n);
    }

    private static void printVersion() {
        System.out.println(String.format("Java Simple Telnet Client %s.\n%s.", "1.4.3", "(C) Copyright 2018 by Maxim V. Malenkov. 'Nauka' LLC, Kaliningrad, Russia"));
    }

    private static void printEnvironment() {
        System.out.println("\n--- 8< --- Java runtime environment [begin] --- 8< --- ");
        System.out.println("Java Runtime Environment version: " + System.getProperty("java.version"));
        System.out.println("Java Runtime Environment vendor: " + System.getProperty("java.vendor"));
        System.out.println("Java vendor URL: " + System.getProperty("java.vendor.url"));
        System.out.println("Java installation directory: " + System.getProperty("java.home"));
        System.out.println("Java Virtual Machine specification version: " + System.getProperty("java.vm.specification.version"));
        System.out.println("Java Virtual Machine specification vendor: " + System.getProperty("java.vm.specification.vendor"));
        System.out.println("Java Virtual Machine specification name: " + System.getProperty("java.vm.specification.name"));
        System.out.println("Java Virtual Machine implementation version: " + System.getProperty("java.vm.version"));
        System.out.println("Java Virtual Machine implementation vendor: " + System.getProperty("java.vm.vendor"));
        System.out.println("Java Virtual Machine implementation name: " + System.getProperty("java.vm.name"));
        System.out.println("Java Runtime Environment specification version: " + System.getProperty("java.specification.version"));
        System.out.println("Java Runtime Environment specification vendor: " + System.getProperty("java.specification.vendor"));
        System.out.println("Java Runtime Environment specification name: " + System.getProperty("java.specification.name"));
        System.out.println("Java class format version number: " + System.getProperty("java.class.version"));
        System.out.println("Java class path: " + System.getProperty("java.class.path"));
        System.out.println("List of paths to search when loading libraries: " + System.getProperty("java.library.path"));
        System.out.println("Default temp file path: " + System.getProperty("java.io.tmpdir"));
        System.out.println("Name of JIT compiler to use: " + System.getProperty("java.compiler"));
        System.out.println("Path of extension directory or directories: " + System.getProperty("java.ext.dirs"));
        System.out.println("Operating system name: " + System.getProperty("os.name"));
        System.out.println("Operating system architecture: " + System.getProperty("os.arch"));
        System.out.println("Operating system version: " + System.getProperty("os.version"));
        System.out.println("File separator (\"/\" on UNIX): " + System.getProperty("file.separator"));
        System.out.println("Path separator (\":\" on UNIX): " + System.getProperty("path.separator"));
        System.out.println("User's account name: " + System.getProperty("user.name"));
        System.out.println("User's home directory: " + System.getProperty("user.home"));
        System.out.println("User's current working directory: " + System.getProperty("user.dir"));
        System.out.println("--- 8< --- Java runtime environment [end] --- 8< --- \n");
    }

    private static int telnetEngine(String string, int n) {
        int n2 = 0;
        remoteIP = string;
        remotePort = n;
        try {
            String string2;
            System.out.print(String.format("Connecting to server %s:%s ... ", remoteIP, remotePort));
            telnetClient.connect(remoteIP, remotePort);
            System.out.println("Ok.");
            Thread thread = new Thread((Runnable)new IPTerminal(), "IPTerminalThread");
            thread.start();
            OutputStream outputStream = telnetClient.getOutputStream();
            byte[] byArray = new byte[1024];
            int n3 = 0;
            boolean bl = false;
            if (multipleTimeout > 0) {
                checkInProgress = true;
                System.out.print("Checking for multple connection in progress... ");
                try {
                    Thread.sleep(multipleTimeout * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (dataReceived) {
                    System.out.println("check failed.");
                    System.exit(-1);
                }
                checkInProgress = false;
                System.out.println("check passed.");
            }
            if (command != null) {
                string2 = IPTerminal.preProcessStr(command);
                try {
                    outputStream.write(string2.getBytes(), 0, string2.length());
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            do {
                if ((n3 = System.in.read(byArray)) <= 0) continue;
                string2 = new String(byArray, 0, n3);
                try {
                    outputStream.write(byArray, 0, n3);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    System.err.println("System.in.read() exeption: " + iOException.getMessage());
                    bl = true;
                }
            } while (n3 > 0 && !bl || telnetClient.isConnected());
            if (!telnetClient.isConnected()) {
                IPTerminal.finalizeAndExit(n2);
            }
        }
        catch (IOException iOException) {
            System.err.println(String.format("Exception while connecting: %s", iOException.getMessage()));
            n2 = -1;
        }
        return n2;
    }

    private static void finalizeAndExit(int n) {
        try {
            System.out.print(String.format("Disconnecting from server %s:%s ... ", remoteIP, remotePort));
            telnetClient.disconnect();
            System.out.println("Ok.");
        }
        catch (IOException iOException) {
            System.err.println(String.format("Exception while disconnecting: %s" + iOException.getMessage(), new Object[0]));
        }
        if (outputFile != null && n == 0) {
            try {
                PrintWriter printWriter = new PrintWriter(outputFile);
                printWriter.print(outputBuffer);
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println(String.format("Can't create or write to output file. Exception: %s", exception.getMessage()));
                n = -1;
            }
        }
        System.exit(n);
    }

    private static int indexOf(byte[] byArray, byte[] byArray2) {
        int[] nArray = IPTerminal.computeFailure(byArray2);
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            while (n > 0 && byArray2[n] != byArray[i]) {
                n = nArray[n - 1];
            }
            if (byArray2[n] == byArray[i]) {
                ++n;
            }
            if (n != byArray2.length) continue;
            return i - byArray2.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        int n = 0;
        for (int i = 1; i < byArray.length; ++i) {
            while (n > 0 && byArray[n] != byArray[i]) {
                n = nArray[n - 1];
            }
            if (byArray[n] == byArray[i]) {
                // empty if block
            }
            nArray[i] = ++n;
        }
        return nArray;
    }

    @Override
    public void run() {
        InputStream inputStream = telnetClient.getInputStream();
        boolean bl = false;
        byte[] byArray = new byte[1024];
        if (terminator != null) {
            bl = true;
            byArray = IPTerminal.preProcessStr(terminator).getBytes();
        }
        try {
            byte[] byArray2 = new byte[1024];
            int n = 0;
            do {
                if ((n = inputStream.read(byArray2)) <= 0) continue;
                dataReceived = true;
                if (checkInProgress) continue;
                String string = new String(byArray2, 0, n);
                printStream.print(string);
                outputBuffer = outputBuffer + string;
                if (!bl || IPTerminal.indexOf(byArray2, byArray) <= 0) continue;
                inputStream.close();
                n = -1;
            } while (n > 0);
        }
        catch (IOException iOException) {
            System.err.println(String.format("Exception while reading socket: %s", iOException.getMessage()));
        }
        if (checkInProgress) {
            System.out.print("Connection closed by server... ");
            try {
                Thread.sleep(multipleTimeout * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IPTerminal.finalizeAndExit(-1);
        } else {
            IPTerminal.finalizeAndExit(0);
        }
    }

    private static String preProcessStr(String string) {
        int n = 0;
        string = "$" + string;
        while ((n = string.indexOf("0x")) > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 4);
            String string4 = string.substring(n + 2, n + 4);
            string = string2 + (char)Integer.parseInt(string4, 16) + string3;
        }
        return string.substring(1);
    }

    static {
        terminator = null;
        command = null;
        outputFile = null;
        outputBuffer = null;
        multipleTimeout = 0;
        dataReceived = false;
        checkInProgress = false;
    }

    private static class Watchdog
    extends Thread {
        private Watchdog() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(execTimeout * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("<<< TIMEOUT >>>");
            System.exit(-1);
        }
    }
}

